<?php
$domain = str_replace(['https://', 'http://'], '', home_url());

$mock_license = '';
if (!empty($license_code)) {
    $len = strlen($license_code);
    $mock_license = substr($license_code, 0, 9) . str_repeat('*', $len - 2) . substr($license_code, $len - 1, 0);
}

$list_courier = aw_shipping_data('couriers');
$list_origin = aw_shipping_data('origins');

$data['origin'] = $data['origin'] ?? 'jakarta';
?>
<form action="" method="POST">
    <input type="hidden" name="page" value="agenwebsite_shipping">
    <input type="hidden" name="action" value="save">
    <input type="hidden" name="tab" value="<?php echo $tab; ?>"/>

    <table class="form-table">
        <tbody>
        <tr>
            <th scope="row">
                <label for="agenwebsite_shipping_license">Kode Lisensi</label>
            </th>
            <td>
                <input <?php echo !$mock_license ? 'name="agenwebsite_shipping[license]"' : '' ?> type="text"
                                                                                                  id="agenwebsite_shipping_license"
                                                                                                  class="regular-text"
                                                                                                  value="<?php echo $mock_license ?? ''; ?>"
                    <?php echo $license_code ? 'disabled' : ''; ?>
                                                                                                  autocomplete="off"/>
                <?php if ($license_code) : ?>
                    <button name="deaktivasi" value="yes" id="activation_button" class="button-primary btn-aw"
                            style="margin-left:10px;">Deaktivasi
                    </button>
                <?php else: ?>
                    <a href="https://www.agenwebsite.com/agenwebsite-shipping-free" target="_blank" class="button-primary btn-aw">
                        Daftar Lisensi Gratis
                    </a>
                <?php endif; ?>
                <p>Masukkan kode lisensi yang kamu dapatkan dari <a href="https://agenwebsite.com/account"
                                                                    target="_blank">halaman akun agenwebsite</a>.</p>
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="agenwebsite_shipping_courier">Aktifkan Kurir</label>
            </th>
            <td>
                <select name="agenwebsite_shipping[courier][]" id="agenwebsite_shipping_courier" multiple
                        class="wc-enhanced-select">
                    <?php foreach ($list_courier as $value) : ?>
                        <option value="<?php echo $value['id']; ?>" <?php echo in_array($value['id'], $data['courier'] ?? []) ? 'selected' : ''; ?>><?php echo $value['title']; ?></option>
                    <?php endforeach; ?>
                </select>
                <p>Pilih Kurir berdasarkan kebutuhan Anda. <strong class="color-red">Free Version hanya bisa memilih 1 kurir</strong></p>
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="agenwebsite_shipping_origin">Basis Kota</label>
            </th>
            <td>
                <select name="agenwebsite_shipping[origin]" id="agenwebsite_shipping_origin" class="wc-enhanced-select">
                    <?php foreach ($list_origin as $value) : ?>
                        <option value="<?php echo $value; ?>" <?php echo $value == $data['origin'] ? 'selected' : ''; ?>><?php echo ucfirst($value); ?></option>
                    <?php endforeach; ?>
                </select>
                <p>Pilih Kota berdasarkan daerah pengiriman Anda.</p>
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="agenwebsite_shipping_zipcode">Kode POS</label>
            </th>
            <td>
                <input name="agenwebsite_shipping[zipcode]" type="text" id="agenwebsite_shipping_zipcode"
                       class="regular-text"
                       value="<?php echo $data['zipcode'] ?? ''; ?>"
                       autocomplete="off"/>
            </td>
        </tr>
        </tbody>
        <?php if (empty($license_code)) : ?>
            <tfoot>
            <tr>
                <th scope="row">

                </th>
                <td>
                    <input type="submit" name="submit" id="submit" class="button button-primary"
                           value="Aktifkan Lisensi">
                </td>
            </tr>
            </tfoot>
        <?php endif; ?>
    </table>
    <?php if ($license_code) : ?>
        <input type="submit" name="submit" id="submit" class="button button-primary" value="Save Changes">
    <?php endif; ?>
</form>