<?php
$validation = aw_shipping_validate_get_license();
$type_license = $validation['type'] ?? '';

$is_premium = $is_premium ?? false;
$disabled_section = ($type_license == 'free' && $is_premium);
?>

<?php
if ($disabled_section) : ?>
    <div class="disabled-section">
        <p>
            Anda menggunakan lisensi gratis, dapatkan fitur ini dengan upgrade ke plugin premium.
            <a href="https://www.agenwebsite.com/products/agenwebsite-shipping/" target="_blank"
               class="button button-primary">UPGRADE TO PREMIUM</a>
        </p>
    </div>
<?php endif; ?>
<form action="" method="POST" <?php echo $disabled_section ? 'class="overlay-disabled-section"' : ''; ?>>
    <table class="form-table">
        <tbody>
        <?php
        foreach ($options as $key => $line) :
            $value = (isset($data[$key]) ? $data[$key] : (isset($line['default']) ? $line['default'] : ''));
            ?>
            <tr class="wrap-<?php echo $key; ?>">
                <?php if ($line['type'] == 'title') : ?>
                    <th class="for-title" scope="row" colspan="2">
                        <h3 for="agenwebsite_shipping[<?php echo $key; ?>]"><?php echo $line['title']; ?></h3>
                        <p><?php echo $line['description']; ?>
                    </th>
                <?php else : ?>
                    <th scope="row">
                        <label for="agenwebsite_shipping[<?php echo $key; ?>]"><?php echo $line['title']; ?></label>
                    </th>
                    <td>
                        <?php
                        if ($line['type'] == 'custom') :
                            require_once $line['path'];
                        elseif ($line['type'] == 'select') :
                            $options = $line['options'];
                            echo '<select ' . ($disabled_section ? 'readonly' : '') . ' class="auto-confirm-select select2" name="agenwebsite_shipping[' . $key . ']" id="' . $key . '">';
                            foreach ($options as $opt_key => $option) :
                                echo '<option value="' . $opt_key . '" ' . selected($value, $opt_key, false) . '>' . $option . '</option>';
                            endforeach;
                            echo '</select>';
                            ?>
                        <?php elseif ($line['type'] == 'checkbox') : ?>
                        <input type="hidden" name="agenwebsite_shipping[<?php echo $key; ?>]" value="no">
                        <input <?php echo($disabled_section ? 'readonly' : ''); ?>
                                name="agenwebsite_shipping[<?php echo $key; ?>]" type="<?php echo $line['type']; ?>"
                                id="<?php echo $key; ?>"
                                value="yes" <?php checked($value, 'yes', true); ?>>

                            <?php if (!empty($line['label'])) : ?>
                            <label for="<?php echo $key; ?>"><span
                                        class="description"><?php echo $line['label']; ?></span></label>
                        <?php endif; ?>
                        <?php elseif ($line['type'] == 'textarea'): ?>
                            <textarea <?php echo($disabled_section ? 'readonly' : ''); ?> name="agenwebsite_shipping[<?php echo $key; ?>]"
                                                                                          id="<?php echo $key; ?>"
                                                                                          class="regular-text <?php echo $line['id']; ?>"
                                                                                          autocomplete="off"
                                                                                          rows="8" <?php echo isset($line['disabled']) && $line['disabled'] == true ? 'disabled' : ''; ?>><?php echo stripcslashes($value); ?></textarea>
                        <?php elseif ($line['type'] == 'select2'):
                        $value = empty($value) ? [] : $value; ?>
                            <select <?php echo($disabled_section ? 'readonly' : ''); ?> class="select2"
                                                                                        name="agenwebsite_shipping[<?php echo $key; ?>][]"
                                                                                        id="<?php echo $key; ?>"
                                                                                        multiple>
                                <?php foreach ($line['options'] as $opt_key => $option) : ?>
                                    <option value="<?php echo $opt_key; ?>" <?php echo in_array($opt_key, $value) ? 'selected' : ''; ?>><?php echo $option; ?></option>
                                <?php endforeach; ?>
                            </select>
                        <?php elseif ($line['type'] == 'courier_service'): ?>
                            <table class="widefat wc_input_table sortable" style="max-width: 800px;">
                                <thead>
                                <tr>
                                    <th class="sort">&nbsp;</th>
                                    <th>Nama
                                        Pengiriman <?php echo aw_shipping_help_tip('Metode pengiriman yang digunakan.'); ?></th>
                                    <th>Tambahan
                                        Biaya <?php echo aw_shipping_help_tip('Biaya tambahan, bisa disetting untuk tambahan biaya packing dan lain-lain.'); ?></th>
                                    <th style="width:14%;text-align:center;">Aktifkan</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                $i = 0;
                                $services = aw_shipping_data('services');
                                $saved_services = $data['services'] ?? [];

                                $shipping_courier = $data['courier'];
                                foreach ($services as $service) :
                                    $options_service = [];
                                    foreach ($saved_services as $line) {
                                        if ($line['courier_id'] == $service['courier_id']) {
                                            $options_service = $line;
                                            break;
                                        }
                                    }

                                    $additionalStyle = '';
                                    $additionalAttrb = '';
                                    $service['is_premium'] = (isset($service['is_premium']) ? $service['is_premium'] : 1);
                                    if (!in_array($service['courier'], $shipping_courier))
                                        $additionalStyle .= 'display: none;';

                                    $service_name = isset($options_service['name']) ? $options_service['name'] : $service['name'];
                                    $service_enable = isset($options_service['enable']) ? $options_service['enable'] : $service['enable'];
                                    $service_extra_cost = isset($options_service['extra_cost']) ? $options_service['extra_cost'] : $service['extra_cost'];

                                    $html = '';
                                    $html .= '<tr class="service" style="' . $additionalStyle . '">';
                                    $html .= '<td class="sort" ' . $additionalAttrb . '></td>';
                                    $html .= '<td><input title="" ' . $additionalAttrb . ' type="text" value="' . $service_name . '" name="agenwebsite_shipping[services][' . $i . '][name]" /></td>';
                                    $html .= '<td><input ' . $additionalAttrb . ' type="number" value="' . ($service_extra_cost ?? 0) . '" name="agenwebsite_shipping[services][' . $i . '][extra_cost]" /></td>';
                                    $html .= '<td style="text-align:center;">
                                            <input ' . $additionalAttrb . ' type="checkbox" value="1" ' . checked($service_enable ?? 0, 1, FALSE) . ' name="agenwebsite_shipping[services][' . $i . '][enable]" />
                                            <input type="hidden" value="' . $service['courier_id'] . '" name="agenwebsite_shipping[services][' . $i . '][courier_id]" />
                                            <input type="hidden" value="' . $service['courier'] . '" name="agenwebsite_shipping[services][' . $i . '][courier]" />
                                            <input type="hidden" value="' . $service['is_premium'] . '" name="agenwebsite_shipping[services][' . $i . '][is_premium]" />
                                        </td>';
                                    $html .= '</tr>';

                                    echo $html;
                                    $i++;
                                endforeach;
                                ?>

                                <?php if (empty($shipping_courier)) : ?>
                                    <tr>
                                        <td colspan="4" style="padding: 20px;text-align: center;">Harap pilih layanan
                                            kurir terlebih dahulu
                                        </td>
                                    </tr>
                                <?php endif; ?>
                                </tbody>
                            </table>
                        <?php elseif ($line['type'] == 'courier_instant_service'): ?>
                            <table class="widefat wc_input_table sortable" style="max-width: 800px;">
                                <thead>
                                <tr>
                                    <th class="sort">&nbsp;</th>
                                    <th>Nama
                                        Pengiriman <?php echo aw_shipping_help_tip('Metode pengiriman yang digunakan.'); ?></th>
                                    <th>Tambahan
                                        Biaya <?php echo aw_shipping_help_tip('Biaya tambahan, bisa disetting untuk tambahan biaya packing dan lain-lain.'); ?></th>
                                    <th style="width:14%;text-align:center;">Aktifkan</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                $i = 0;
                                $services = aw_shipping_data('services-instant');
                                $saved_services = $data['services_instant'] ?? [];

                                $shipping_courier = $data['courier_instant'] ?? [];
                                foreach ($services as $service) :
                                    $options_service = [];
                                    foreach ($saved_services as $line) {
                                        if ($line['courier_id'] == $service['courier_id']) {
                                            $options_service = $line;
                                            break;
                                        }
                                    }

                                    $additionalStyle = '';
                                    $additionalAttrb = '';
                                    $service['is_premium'] = (isset($service['is_premium']) ? $service['is_premium'] : 1);
                                    if (!in_array($service['courier'], $shipping_courier))
                                        $additionalStyle .= 'display: none;';

                                    $service_name = isset($options_service['name']) ? $options_service['name'] : $service['name'];
                                    $service_enable = isset($options_service['name']) ? $options_service['enable'] : $service['enable'];
                                    $service_extra_cost = isset($options_service['extra_cost']) ? $options_service['extra_cost'] : $service['extra_cost'];

                                    $html = '';
                                    $html .= '<tr class="service" style="' . $additionalStyle . '">';
                                    $html .= '<td class="sort" ' . $additionalAttrb . '></td>';
                                    $html .= '<td><input title="" ' . $additionalAttrb . ' type="text" value="' . $service_name . '" name="agenwebsite_shipping[services_instant][' . $i . '][name]" /></td>';
                                    $html .= '<td><input ' . $additionalAttrb . ' type="number" value="' . ($service_extra_cost ?? 0) . '" name="agenwebsite_shipping[services_instant][' . $i . '][extra_cost]" /></td>';
                                    $html .= '<td style="text-align:center;">
                                            <input ' . $additionalAttrb . ' type="checkbox" value="1" ' . checked($service_enable ?? 0, 1, FALSE) . ' name="agenwebsite_shipping[services_instant][' . $i . '][enable]" />
                                            <input type="hidden" value="' . $service['courier_id'] . '" name="agenwebsite_shipping[services_instant][' . $i . '][courier_id]" />
                                            <input type="hidden" value="' . $service['courier'] . '" name="agenwebsite_shipping[services_instant][' . $i . '][courier]" />
                                            <input type="hidden" value="' . $service['is_premium'] . '" name="agenwebsite_shipping[services_instant][' . $i . '][is_premium]" />
                                        </td>';
                                    $html .= '</tr>';

                                    echo $html;
                                    $i++;
                                endforeach;
                                ?>

                                <?php if (empty($shipping_courier)) : ?>
                                    <tr>
                                        <td colspan="4" style="padding: 20px;text-align: center;">Harap pilih layanan
                                            kurir terlebih dahulu
                                        </td>
                                    </tr>
                                <?php endif; ?>
                                </tbody>
                            </table>
                        <?php elseif ($line['type'] == 'courier_international_service'): ?>
                            <table class="widefat wc_input_table sortable" style="max-width: 800px;">
                                <thead>
                                <tr>
                                    <th class="sort">&nbsp;</th>
                                    <th>Nama
                                        Pengiriman <?php echo aw_shipping_help_tip('Metode pengiriman yang digunakan.'); ?></th>
                                    <th>Tambahan
                                        Biaya <?php echo aw_shipping_help_tip('Biaya tambahan, bisa disetting untuk tambahan biaya packing dan lain-lain.'); ?></th>
                                    <th style="width:14%;text-align:center;">Aktifkan</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                $i = 0;
                                $services = aw_shipping_data('services-international');
                                $saved_services = $data['services_international'] ?? [];

                                $shipping_courier = $data['courier_international'] ?? [];
                                foreach ($services as $service) :
                                    $options_service = [];
                                    foreach ($saved_services as $line) {
                                        if ($line['courier_id'] == $service['courier_id']) {
                                            $options_service = $line;
                                            break;
                                        }
                                    }

                                    $additionalStyle = '';
                                    $additionalAttrb = '';
                                    $service['is_premium'] = (isset($service['is_premium']) ? $service['is_premium'] : 1);
                                    if (!in_array($service['courier'], $shipping_courier))
                                        $additionalStyle .= 'display: none;';

                                    $service_name = isset($options_service['name']) ? $options_service['name'] : $service['name'];
                                    $service_enable = isset($options_service['name']) ? $options_service['enable'] : $service['enable'];
                                    $service_extra_cost = isset($options_service['extra_cost']) ? $options_service['extra_cost'] : $service['extra_cost'];

                                    $html = '';
                                    $html .= '<tr class="service" style="' . $additionalStyle . '">';
                                    $html .= '<td class="sort" ' . $additionalAttrb . '></td>';
                                    $html .= '<td><input title="" ' . $additionalAttrb . ' type="text" value="' . $service_name . '" name="agenwebsite_shipping[services_international][' . $i . '][name]" /></td>';
                                    $html .= '<td><input ' . $additionalAttrb . ' type="number" value="' . ($service_extra_cost ?? 0) . '" name="agenwebsite_shipping[services_international][' . $i . '][extra_cost]" /></td>';
                                    $html .= '<td style="text-align:center;">
                                            <input ' . $additionalAttrb . ' type="checkbox" value="1" ' . checked($service_enable ?? 0, 1, FALSE) . ' name="agenwebsite_shipping[services_international][' . $i . '][enable]" />
                                            <input type="hidden" value="' . $service['courier_id'] . '" name="agenwebsite_shipping[services_international][' . $i . '][courier_id]" />
                                            <input type="hidden" value="' . $service['courier'] . '" name="agenwebsite_shipping[services_international][' . $i . '][courier]" />
                                            <input type="hidden" value="' . $service['is_premium'] . '" name="agenwebsite_shipping[services_international][' . $i . '][is_premium]" />
                                        </td>';
                                    $html .= '</tr>';

                                    echo $html;
                                    $i++;
                                endforeach;
                                ?>

                                <?php if (empty($shipping_courier)) : ?>
                                    <tr>
                                        <td colspan="4" style="padding: 20px;text-align: center;">Harap pilih layanan
                                            kurir terlebih dahulu
                                        </td>
                                    </tr>
                                <?php endif; ?>
                                </tbody>
                            </table>
                        <?php elseif ($line['type'] == 'courier') :
                        $list_courier = aw_shipping_data('couriers');
                        ?>
                            <select name="agenwebsite_shipping[courier][]" id="agenwebsite_shipping_courier" multiple
                                    class="wc-enhanced-select">
                                <?php foreach ($list_courier as $value) : ?>
                                    <option value="<?php echo $value['id']; ?>" <?php echo in_array($value['id'], $data['courier'] ?? []) ? 'selected' : ''; ?>><?php echo $value['title']; ?></option>
                                <?php endforeach; ?>
                            </select>
                        <?php elseif ($line['type'] == 'courier_instant') :
                        $list_courier = aw_shipping_data('courier-instant');
                        ?>
                            <select name="agenwebsite_shipping[courier_instant][]"
                                    id="agenwebsite_shipping_courier_instant" multiple
                                    class="wc-enhanced-select">
                                <?php foreach ($list_courier as $value) : ?>
                                    <option value="<?php echo $value['id']; ?>" <?php echo in_array($value['id'], $data['courier_instant'] ?? []) ? 'selected' : ''; ?>><?php echo $value['title']; ?></option>
                                <?php endforeach; ?>
                            </select>
                        <?php elseif ($line['type'] == 'courier_international') :
                        $list_courier = aw_shipping_data('courier-international');
                        ?>
                            <select name="agenwebsite_shipping[courier_international][]"
                                    id="agenwebsite_shipping_courier_international" multiple
                                    class="wc-enhanced-select">
                                <?php foreach ($list_courier as $value) : ?>
                                    <option value="<?php echo $value['id']; ?>" <?php echo in_array($value['id'], $data['courier_international'] ?? []) ? 'selected' : ''; ?>><?php echo $value['title']; ?></option>
                                <?php endforeach; ?>
                            </select>
                        <?php elseif ($line['type'] == 'google_maps') :
                        $api_key = $data['google_maps_api_key'] ?? '';
                        $default_latitude = !empty($data['position_latitude']) ? $data['position_latitude'] : '-6.1753917';
                        $default_longitude = !empty($data['position_longitude']) ? $data['position_longitude'] : '106.8271533';
                        ?>

                        <?php if (empty($api_key)) : ?>
                            <p>Maps akan tampil disini, harap melakukan setup Google Maps API Key terlebih dahulu</p>
                        <?php continue; ?>
                        <?php endif; ?>

                        <input id="pac-input" class="controls" type="text" placeholder="Search Box"/>

                            <div id="maps" style="width: 100%; height: 400px"></div>

                            <script type="text/javascript">
                                var map;
                                var marker;
                                var geocoder;

                                function initMap() {
                                    var myLatLng = {
                                        lat: <?php echo $default_latitude; ?>,
                                        lng: <?php echo $default_longitude; ?>};

                                    map = new google.maps.Map(document.getElementById("maps"), {
                                        center: myLatLng,
                                        zoom: 15,
                                        mapTypeControl: false,
                                        fullscreenControl: false,
                                        streetViewControl: false
                                    });

                                    var input = document.getElementById("pac-input");
                                    var autocomplete = new google.maps.places.Autocomplete(input);
                                    autocomplete.setComponentRestrictions(
                                        {"country": ["id"]});

                                    google.maps.event.trigger(input, "focus");
                                    google.maps.event.trigger(input, "keydown", {keyCode: 13});

                                    geocoder = new google.maps.Geocoder;
                                    addMarker(map, myLatLng);
                                    geocodeLatLng(geocoder, map, myLatLng);

                                    // Create the search box and link it to the UI element.

                                    if (navigator.geolocation && myLatLng.lat == <?php echo $default_latitude; ?> && myLatLng.lng == <?php echo $default_longitude; ?>) {
                                        navigator.geolocation.getCurrentPosition(function (position) {
                                            myLatLng = {
                                                lat: position.coords.latitude,
                                                lng: position.coords.longitude
                                            };
                                            map.setCenter(myLatLng);

                                            marker.setPosition(myLatLng);
                                            setLatLng(myLatLng);
                                            geocodeLatLng(geocoder, map, myLatLng);
                                        }, function () {
                                            marker.setPosition(myLatLng);
                                            setLatLng(myLatLng);
                                            geocodeLatLng(geocoder, map, myLatLng);
                                        });
                                    } else {
                                        marker.setPosition(myLatLng);
                                        setLatLng(myLatLng);
                                        geocodeLatLng(geocoder, map, myLatLng);
                                    }

                                    window.google.maps.event.addListener(map, "drag", function (event) {
                                        var position = marker.getPosition();
                                        myLatLng = {
                                            lat: position.lat(),
                                            lng: position.lng()
                                        };
                                        setLatLng(myLatLng);
                                        marker.setPosition(map.getCenter());
                                        geocodeLatLng(geocoder, map, myLatLng);
                                    });

                                    autocomplete.addListener("place_changed", function () {
                                        var place = autocomplete.getPlace();

                                        if (!place.geometry) {
                                            // User entered the name of a Place that was not suggested and
                                            // pressed the Enter key, or the Place Details request failed.
                                            return;
                                        }

                                        // If the place has a geometry, then present it on a map.
                                        map.setCenter(place.geometry.location);
                                        marker.setPosition(place.geometry.location);

                                        var position = marker.getPosition();
                                        myLatLng = {
                                            lat: place.geometry.location.lat(),
                                            lng: place.geometry.location.lng()
                                        };
                                        setLatLng(myLatLng);
                                        geocodeLatLng(geocoder, map, myLatLng);
                                    });

                                    addYourLocationButton(map, marker);

                                    // Add default value address from
                                    if (myLatLng.lat != <?php echo $default_latitude; ?> && myLatLng.lng != <?php echo $default_longitude; ?>) {
                                        var position = marker.getPosition();
                                        myLatLng = {
                                            lat: position.lat(),
                                            lng: position.lng()
                                        };
                                        setgeocodeLatLng(geocoder, map, myLatLng);
                                    }
                                }

                                function gm_authFailure() {
                                    document.getElementsByClassName("error-maps")[0].innerHTML = "API Key Anda invalid. <a href=\"https://www.agenwebsite.com/api-key-google-maps\" target=\"_blank\">Tutorial integrasi Google Maps</a>";
                                }

                                function addYourLocationButton(map, marker) {
                                    var controlDiv = document.createElement("div");

                                    var firstChild = document.createElement("button");
                                    firstChild.style.backgroundColor = "#fff";
                                    firstChild.style.border = "none";
                                    firstChild.style.outline = "none";
                                    firstChild.style.width = "28px";
                                    firstChild.style.height = "28px";
                                    firstChild.style.borderRadius = "2px";
                                    firstChild.style.boxShadow = "0 1px 4px rgba(0,0,0,0.3)";
                                    firstChild.style.cursor = "pointer";
                                    firstChild.style.marginRight = "10px";
                                    firstChild.style.padding = "0px";
                                    firstChild.type = "button";
                                    firstChild.title = "Your Location";
                                    controlDiv.appendChild(firstChild);

                                    var secondChild = document.createElement("div");
                                    secondChild.style.margin = "5px";
                                    secondChild.style.width = "18px";
                                    secondChild.style.height = "18px";
                                    secondChild.style.backgroundImage = "url(https://maps.gstatic.com/tactile/mylocation/mylocation-sprite-1x.png)";
                                    secondChild.style.backgroundSize = "180px 18px";
                                    secondChild.style.backgroundPosition = "0px 0px";
                                    secondChild.style.backgroundRepeat = "no-repeat";
                                    secondChild.id = "you_location_img";
                                    firstChild.appendChild(secondChild);

                                    google.maps.event.addListener(map, "dragend", function () {
                                        jQuery("#you_location_img").css("background-position", "0px 0px");
                                    });

                                    firstChild.addEventListener("click", function () {
                                        var imgX = "0";
                                        var animationInterval = setInterval(function () {
                                            if (imgX == "-18") imgX = "0";
                                            else imgX = "-18";
                                            jQuery("#you_location_img").css("background-position", imgX + "px 0px");
                                        }, 500);
                                        if (navigator.geolocation) {
                                            navigator.geolocation.getCurrentPosition(function (position) {
                                                var myLatLng = {
                                                    lat: position.coords.latitude,
                                                    lng: position.coords.longitude
                                                };
                                                map.setCenter(myLatLng);

                                                marker.setPosition(myLatLng);
                                                setLatLng(myLatLng);
                                                geocodeLatLng(geocoder, map, myLatLng);

                                                clearInterval(animationInterval);
                                                jQuery("#you_location_img").css("background-position", "-144px 0px");
                                            });
                                        } else {
                                            clearInterval(animationInterval);
                                            jQuery("#you_location_img").css("background-position", "0px 0px");
                                        }
                                    });

                                    controlDiv.index = 1;
                                    map.controls[google.maps.ControlPosition.RIGHT_BOTTOM].push(controlDiv);
                                }

                                function addMarker(map, latLng) {
                                    marker = new google.maps.Marker({
                                        position: latLng,
                                        map: map,
                                        title: "Your Location"
                                    });
                                }

                                function setLatLng(latlng) {
                                    document.getElementById("position_latitude").value = latlng.lat;
                                    document.getElementById("position_longitude").value = latlng.lng;
                                }

                                function geocodeLatLng(geocoder, map, latlng) {
                                    geocoder.geocode({"location": latlng}, function (results, status) {
                                        if (status === "OK") {
                                            if (results[0]) {
                                                var address = results[0].formatted_address;
                                                document.getElementById("position_address").value = address;
                                            } else {
                                                // Map Not Found
                                            }
                                        } else {
                                            // Geocoder error
                                        }
                                    });
                                }

                                // Set geocode name from latitude longitude into element
                                function setgeocodeLatLng(geocoder, map, latlng) {
                                    geocoder.geocode({"location": latlng}, function (results, status) {
                                        if (status === "OK") {
                                            if (results[0]) {
                                                var address = results[0].formatted_address;

                                                document.getElementById("position_address").value = address;
                                            } else {
                                                // Map Not Found
                                            }
                                        } else {
                                            // Geocoder error
                                        }
                                    });
                                }

                                function selectFirstResult() {
                                    var firstResult = jQuery(".pac-container .pac-item:first").text();

                                    var geocoder = new google.maps.Geocoder();
                                    geocoder.geocode({"address": firstResult}, function (results, status) {
                                        if (status == google.maps.GeocoderStatus.OK) {
                                            var lat = results[0].geometry.location.lat(),
                                                lng = results[0].geometry.location.lng(),
                                                placeName = results[0].address_components[0].long_name,
                                                latlng = new google.maps.LatLng(lat, lng);

                                            myLatLng = {
                                                lat: lat,
                                                lng: lng
                                            };

                                            map.setCenter(myLatLng);
                                            marker.setPosition(myLatLng);
                                            setLatLng(myLatLng);
                                            geocodeLatLng(geocoder, map, myLatLng);
                                        }
                                    });
                                }

                                function changeMaps(latlng) {
                                    myLatLng = {
                                        lat: latlng.lat,
                                        lng: latlng.lng
                                    };
                                    map.setCenter(myLatLng);
                                    marker.setPosition(map.getCenter());
                                    geocodeLatLng(geocoder, map, myLatLng);
                                }

                                jQuery(document).ready(function ($) {
                                    $("#position_latitude, #position_longitude").change(function () {
                                        var latlng = {
                                            lat: parseFloat($("#position_latitude").val()),
                                            lng: parseFloat($("#position_longitude").val())
                                        };
                                        changeMaps(latlng);
                                    });

                                    $("#position_address").attr("readonly", true);
                                    $("#position_latitude").attr("readonly", true);
                                    $("#position_longitude").attr("readonly", true);
                                });
                            </script>

                            <script src="https://maps.googleapis.com/maps/api/js?key=<?php echo $api_key; ?>&amp;callback=initMap&amp;libraries=places&amp;ver=6.7.1"
                                    id="enqueue-maps-script-js"></script>
                        <?php elseif ($line['type'] != 'title') : ?>
                        <input <?php echo($disabled_section ? 'readonly' : ''); ?>
                                name="agenwebsite_shipping[<?php echo $key; ?>]" type="<?php echo $line['type']; ?>"
                                id="<?php echo $key; ?>" value="<?php echo $value; ?>"
                                class="regular-text"
                            <?php echo isset($line['disabled']) && $line['disabled'] == true ? 'disabled' : ''; ?>
                            <?php echo isset($line['readonly']) && $line['readonly'] == true ? 'readonly' : ''; ?>
                                autocomplete="off">
                        <?php endif; ?>
                        <?php if (!empty($line['description'])) : ?>
                            <p><?php echo $line['description']; ?></p>
                        <?php endif; ?>
                    </td>
                <?php endif; ?>
            </tr>
        <?php endforeach; ?>
        </tbody>
        <tfoot>
        </tfoot>
    </table>

    <?php
    if (!$disabled_section) : ?>
        <input type="hidden" name="page" value="agenwebsite_shipping">
        <input type="hidden" name="action" value="save">
        <input type="hidden" name="tab" value="<?php echo $tab; ?>"/>
        <input type="submit" name="submit" id="submit" class="button button-primary" value="Save Changes">
    <?php endif; ?>
</form>