<?php
/**
 * Admin View: Section - AgenWebsite Product Status
 */

if ($data['success']) {
    $icon = 'good.png';
} else {
    $icon = 'bad.png';
}
?>
    <tr>
        <td colspan="3" class="load_status">
            <div style="display:flex;justify-content: center;align-items: center">
                <img src="<?php echo aw_shipping_plugin_url() . '/assets/images/' . $icon; ?>" alt="status" style="margin-right: 5px;">
                <span><b><?php echo $data['message']; ?></b></span>
            </div>
        </td>
    </tr>
<?php
if ($data['success']) {
    foreach ($data['result'] as $title => $value) {

        // replace dash to space
        $value = ($title == 'basis_kota') ? str_replace('-', ' ', $value) : $value;

        // replace underscore to space
        $title = str_replace('_', ' ', $title);

        // not print value array
        $no_print = array('code', 'message');

        // convert format
        if ($title == 'expire date')
            $value = aw_shipping_convert_date($value, 'd M Y');

        // loop value from api
        if (!in_array($title, $no_print)) {
            $class = 'yes';
            if ($title == 'response time') {
                if ($value > intval(1000)) {
                    $class = 'no';
                }

                $value = $value . 'ms';
            }
            echo '<tr>';
            echo '<td>' . ucfirst($title) . '</td>';
            echo '<td><mark class="' . $class . '">' . ucfirst($value) . '</mark></td>';
            echo '<td></td>';
            echo '</tr>';
        }
    }
    ?>
<?php } ?>