<?php
/**
 * AgenWebsite Shipping - Function Shipping
 *
 * @author AgenWebsite Shipping
 * @package AgenWebsite Shipping
 * @since 1.0.0
 */
if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

function aw_shipping_options()
{
    return get_option('aw_shipping_settings', []);
}

function aw_shipping_license()
{
    $options = aw_shipping_options();
    return isset($options['license']) ? $options['license'] : '';
}

function aw_shipping_validate_license($post_options)
{
    $license = isset($post_options['license']) ? $post_options['license'] : '';
    if (empty($license)) {
        return false;
    }
    $api = new AWShipping_Api();

    $body = [
        'license' => $license,
        'kota' => $post_options['origin'],
        'kodepos' => $post_options['zipcode'],
    ];

    $response = $api->remote_post('license', [], $body);

    return [
        'message' => $response['message'],
        'success' => $response['status'] == 'success' ? true : false,
        'result' => $response['result']
    ];
}

function aw_shipping_validate_get_license()
{
    return get_option('aw_shipping_license', '');
}

function aw_shipping_data($type)
{
    $file = aw_shipping_plugin_path() . '/data/' . $type . '.json';
    if (file_exists($file)) {
        return json_decode(file_get_contents($file), true);
    }
    return [];
}

function aw_shipping_help_tip($tip, $float = 'none')
{
    return '<img class="help_tip" data-tip="' . $tip . '" src="' . aw_shipping_plugin_url() . '/assets/images/help.png" height="16" width="16" style="float:' . $float . ';" />';
}

function aw_shipping_convert_date($date, $format)
{
    date_default_timezone_set('Asia/Jakarta');

    return date($format, strtotime($date));
}

function aw_shipping_calculate_weight($products = NULL)
{
    $output = array();
    $return = 'int';
    $weight = 0;
    $weight_unit = get_option('woocommerce_weight_unit');
    $settings = aw_shipping_options();

    if (is_null($products)) {
        $return = 'array';
        $default_weight = $settings['default_weight'] ?? 1;
        $products = WC()->cart->get_cart();
    } else {
        $default_weight = $settings['default_weight'] ?? 1;
    }

    if ($weight_unit == 'g')
        $default_weight = $default_weight * 1000;

    if (is_array($products)) {
        foreach ($products as $item_id => $item) {
            $product = $item['data'];

            if ($product->is_downloadable() == false && $product->is_virtual() == false) {
                $product_weight = $product->get_weight() ? $product->get_weight() : $default_weight;
                $product_weight = ($product_weight == 0) ? $default_weight : $product_weight;
                $product_weight = $product_weight * $item['quantity'];

                // Change product weight to kilograms
                if ($weight_unit == 'g')
                    $product_weight = $product_weight / 1000;

                $weight += $product_weight;
            }
        }
    } else {
        $product = $products;

        if ($product->is_downloadable() == false && $product->is_virtual() == false) {
            $product_weight = $product->get_weight() ? $product->get_weight() : $default_weight;
            $product_weight = ($product_weight == 0) ? $default_weight : $product_weight;

            // Change product weight to kilograms
            if ($weight_unit == 'g')
                $product_weight = $product_weight / 1000;

            $weight += $product_weight;
        }
    }

    $weight = number_format((float)$weight, 2, '.', '');
    $weight = ($weight <= 0 ? 1 : $weight);

    $output['weight'] = $weight;
    return ($return == 'array') ? $output : $weight;
}

function aw_shipping_get_costs($state, $city, $district, $zipcode, $weight, $courier, $customer_lat = '')
{
    $output = [];

    if (empty($courier)) return false;

    $list_courier = implode("|", $courier);
    $province = strlen($state) <= 2 ? aw_shipping_get_provinsi_name($state) : $state;
    $params = array(
        'province' => $province,
        'city' => $city,
        'district' => $district,
        'zipcode' => $zipcode,
        'weight' => $weight,
        'courier' => $list_courier,
    );

    $options = aw_shipping_options();
    $services = $options['services'] ?? [];
    $instant_enable = $options['instant_enable'] ?? 'no';
    if ($instant_enable == 'yes') {
        $origin_latlng = $options['position_latitude'] . ',' . $options['position_longitude'];
        $params['origin_latlng'] = $origin_latlng;
        $params['latlng'] = $customer_lat;

        $services_instant = $options['services_instant'] ?? [];
        $services = array_merge($services, $services_instant);
    }

    // get data from API
    $api = new AWShipping_Api();
    $response = $api->remote_post('price', [], $params);

    // validate response status
    if ($response['status'] != 'error') {
        $tarif = $response['result'];

        foreach ($services as $service) {
            $service_courier = $service['courier'];
            if (!in_array($service_courier, $courier)) continue;

            $service_id = strtolower(trim($service['courier_id']));
            $service_name = $service['name'];
            $service_enable = $service['enable'] ?? 0;
            $service_extra_cost = $service['extra_cost'];

            if ($service_enable) {
                $service_api = [];
                foreach ($tarif as $line) {
                    if ($line['service'] == $service_id) {
                        $service_api = $line;
                        break;
                    }
                }
                if (!empty($service_api)) {
                    $cost = $service_api['price'] + $service_extra_cost;
                    $etd = $service_api['etd'];

                    $output[] = [
                        'courier' => $service_courier,
                        'service_id' => $service_id,
                        'label' => $service_name,
                        'price' => $cost,
                        'etd' => $etd
                    ];
                }
            }
        }
    }

    return $output;
}

function aw_shipping_get_costs_international($country, $zipcode, $weight, $courier)
{
    $output = [];

    if (empty($courier)) return false;

    $list_courier = implode("|", $courier);
    $params = array(
        'country' => $country,
        'zipcode' => $zipcode,
        'weight' => $weight,
        'courier' => $list_courier,
    );

    // get data from API
    $api = new AWShipping_Api();
    $response = $api->remote_post('price-international', [], $params);

    $options = aw_shipping_options();
    $services = $options['services_international'] ?? [];

    // validate response status
    if ($response['status'] != 'error') {
        $tarif = $response['result'];

        foreach ($services as $service) {
            $service_courier = $service['courier'];
            if (!in_array($service_courier, $courier)) continue;

            $service_id = strtolower(trim($service['courier_id']));
            $service_name = $service['name'];
            $service_enable = $service['enable'] ?? 0;
            $service_extra_cost = $service['extra_cost'];

            if ($service_enable) {
                $service_api = [];
                foreach ($tarif as $line) {
                    if ($line['service'] == $service_id) {
                        $service_api = $line;
                        break;
                    }
                }
                if (!empty($service_api)) {
                    $cost = $service_api['price'] + $service_extra_cost;
                    $etd = $service_api['etd'];

                    $output[] = [
                        'courier' => $service_courier,
                        'service_id' => $service_id,
                        'label' => $service_name,
                        'price' => $cost,
                        'etd' => $etd
                    ];
                }
            }
        }
    }

    return $output;
}

function aw_shipping_get_provinsi_name($id)
{
    $provinsi = '';
    $states = WC()->countries->get_states('ID');

    foreach ($states as $id_provinsi => $nama_provinsi) {
        if ($id_provinsi == $id) {
            $provinsi = $nama_provinsi;
        }
    }

    return $provinsi;
}