<?php
/**
 * AgenWebsite Shipping - WooCommerce Frontend
 *
 * @author AgenWebsite Shipping
 * @package AgenWebsite Shipping
 * @since 1.0.0
 */
if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

class AWShipping_Main extends WC_Shipping_Method
{
    /**
     * Constructor
     *
     * @access public
     * @return void
     * @since 1.0.0
     **/
    public function __construct()
    {
        parent::__construct();

        $this->id = 'agenwebsite_shipping';
        $this->method_title = __('AgenWebsite Shipping', 'agenwebsite-shipping');
        $this->method_description = __('Plugin AgenWebsite Shipping mengintegrasikan ongkos kirim dengan total belanja pelanggan Anda.', 'agenwebsite-shipping');

        $this->init();
    }

    /**
     * Init function.
     */
    public function init()
    {

    }

    public function calculate_shipping($package = array())
    {
        $options = aw_shipping_options();
        $enabler = $options['enable'] ?? 'yes';
        if ($enabler == 'no') {
            return false;
        }

        $country = WC()->customer->get_shipping_country();
        $state = WC()->customer->get_shipping_state();
        $city = WC()->customer->get_shipping_city();
        $zipcode = WC()->customer->get_shipping_postcode();

        $customer_id = WC()->session->get_customer_id();
        $customer_lat = WC()->session->get('agenwebsite_billing_pinpoint_' . $customer_id) ?? "";

        $explode_field_city = explode(', ', $city);
        if (count($explode_field_city) < 2) return false;

        $city = $explode_field_city[0];
        $district = $explode_field_city[1];

        $couriers = $options['courier'] ?? [];
        $couriers = array_merge($couriers, $options['courier_instant'] ?? []);
        $couriers = array_unique($couriers);

        $total_weight = aw_shipping_calculate_weight($package['contents']);

        $api_cost = [];
        if ($country == 'ID') {
            $api_cost = aw_shipping_get_costs($state, $city, $district, $zipcode, $total_weight, $couriers, $customer_lat);
        }

        if (($options['instant_enable'] ?? 'no') == 'yes' && $country != 'ID') {
            $couriers_international = $options['courier_international'] ?? [];
            $api_cost_international = aw_shipping_get_costs_international($country, $zipcode, $total_weight, $couriers_international);

            if (!empty($api_cost_international)) {
                $api_cost = array_merge($api_cost, $api_cost_international);
            }
        }

        if (empty($api_cost)) return false;

        if (sizeof($package) == 0) return false;

        foreach ($api_cost as $line) {
            $rate = apply_filters('woocommerce_agenwebsite_tarif', array(
                'id' => $this->id . '_' . $line['service_id'],
                'label' => $line['label'] . ' (' . $line['etd'] . ')',
                'cost' => $line['price'],
                'meta_data' => $line
            ));

            $this->add_rate($rate);
        }

        return true;
    }

}
