<?php
/**
 * AgenWebsite Shipping - WooCommerce Frontend
 *
 * @author AgenWebsite Shipping
 * @package AgenWebsite Shipping
 * @since 1.0.0
 */
if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

if (!class_exists('AWShipping_WooFrontend')) :

    class AWShipping_WooFrontend
    {

        public function __construct()
        {
            add_action('woocommerce_shipping_init', array(&$this, 'shipping_method'));
            add_filter('woocommerce_shipping_methods', array(&$this, 'add_agenwebsite_shipping_method'));

            add_filter('woocommerce_checkout_fields', array($this, 'one_checkout_fields'), 10);

            add_action('woocommerce_review_order_before_shipping', array(&$this, 'show_total_weight'));
        }

        public function shipping_method()
        {
            include_once('class-woocommerce-shipping.php');
        }

        public function add_agenwebsite_shipping_method($methods)
        {
            $methods[] = 'AWShipping_Main';
            return $methods;
        }

        public function one_checkout_fields($fields)
        {
            $options = aw_shipping_options();

            $enable = $options['enable'] ?? 'no';
            if ($enable) {
                $fields['billing']['agenwebsite_billing_city'] = array(
                    'label' => __('Provinsi / Kota / Kecamatan', 'woocommerce'),
                    'required' => false,
                    'class' => array('form-row-wide', 'address-field'),
                    'autocomplete' => 'address-level1',
                    'priority' => 65,
                    'placeholder' => 'Tulis Nama Alamat / Kota / Kecamatan tujuan pengiriman'
                );
                $fields['shipping']['agenwebsite_shipping_city'] = array(
                    'label' => __('Provinsi / Kota / Kecamatan', 'woocommerce'),
                    'required' => false,
                    'class' => array('form-row-wide', 'address-field'),
                    'autocomplete' => 'address-level1',
                    'priority' => 65,
                    'placeholder' => 'Tulis Nama Alamat / Kota / Kecamatan tujuan pengiriman'
                );
            }
            return $fields;
        }

        public function show_total_weight()
        {
            $options = aw_shipping_options();
            $total_weight_is_display = $options['enable_total_weight'] ?? 'no';
            $total_weight = aw_shipping_calculate_weight();
            $weight_unit = get_option('woocommerce_weight_unit');
            $total_weight['weight'] = ($weight_unit == 'g' ? ($total_weight['weight'] * 1000) : $total_weight['weight']);

            if ((array_key_exists('virtual', $total_weight) && $total_weight['virtual'] !== 'yes') || $total_weight['weight'] !== 0 && $total_weight_is_display == 'yes') {
                echo '<tr>' . "\n";
                echo '<th>' . __('Total weight', 'agenwebsite-shipping') . '</th>' . "\n";
                echo '<td>' . $total_weight['weight'] . apply_filters('woocommerce_agenwebsite_weight_unit', $weight_unit) . '</td>' . "\n";
                echo '</tr>' . "\n";
            }
        }
    }

    new AWShipping_WooFrontend();

endif;