<?php
/**
 * AgenWebsite Shipping Settings
 *
 * @author AgenWebsite Shipping
 * @package AgenWebsite Shipping
 * @since 1.0.0
 */
if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

if (!class_exists('AWShipping_Settings')) :

    class AWShipping_Settings
    {

        /**
         * Option name
         */
        private $opt_setting_key = 'aw_shipping_settings';
        private $opt_license_key = 'aw_shipping_license';

        /**
         * Constructor
         *
         * @return void
         * @since 1.0.0
         */
        public function __construct()
        {
            add_action('admin_enqueue_scripts', array($this, 'admin_enqueue'));
            add_action('admin_menu', array($this, 'add_menu_page'));
            add_action('init', array($this, 'default_setting'));
        }

        /**
         * Change settings to default setting
         *
         * @access  public
         * @return  void
         * @since   1.0.0
         */
        public function default_setting($force = false)
        {
        }

        /**
         * Enqueue scripts and style
         *
         * @access  public
         * @return  void
         * @since   1.0.0
         */
        public function admin_enqueue()
        {
            if (isset($_GET['page']) && $_GET['page'] == 'agenwebsite_shipping') {
                wp_enqueue_style('select2');
                wp_enqueue_style('aw-shipping-admin', aw_shipping_plugin_url() . '/assets/css/admin.css', array('woocommerce_admin_styles'), '1.0.0', 'all');
                wp_enqueue_script('aw-shipping-admin', aw_shipping_plugin_url() . '/assets/js/admin.js', array('jquery', 'jquery-ui-sortable', 'wc-enhanced-select'), '1.0.0', true);

                $args = array(
                    'ajax_url' => admin_url('admin-ajax.php'),
                    '_wpnonce' => wp_create_nonce('aw_shipping_nonce'),
                    'active_license' => !empty(aw_shipping_license()) ? true : false
                );
                wp_localize_script('aw-shipping-admin', 'aw_shipping', $args);
            }
        }

        /**
         * Adding Menu
         *
         * @access  public
         * @return  void
         * @since   1.0.0
         */
        public function add_menu_page()
        {
            add_menu_page(
                'AgenWebsite Shipping',
                'AgenWebsite Shipping',
                'manage_options',
                'agenwebsite_shipping',
                array($this, 'submenu_page_callback'),
                ''
            );
        }

        /**
         * Print the UI Settings
         *
         * @access  public
         * @return  void
         * @since   1.0.0
         */
        public function submenu_page_callback()
        {
            $success_update = '';
            $success_message = '';
            $error_update = '';
            $error_message = '';

            // Process save data
            if (isset($_POST['action'])) {
                if ($_POST['action'] == 'save') {
                    $post_options = $_POST['agenwebsite_shipping'] ?? array();

                    if (isset($_POST['deaktivasi']) && $_POST['deaktivasi'] == 'yes') {
                        $post_options['license'] = '';

                        update_option($this->opt_setting_key, $post_options);

                        $success_update = true;
                        $success_message = 'Settings saved.';
                    }

                    $license = $post_options['license'] ?? '';
                    if ($license) {
                        $validation = aw_shipping_validate_license($post_options);
                        if (!$validation['success']) {
                            $error_update = true;
                            $error_message = $validation['message'];
                        } else {
                            update_option($this->opt_license_key, $validation['result']);
                        }
                    }

                    $validation = aw_shipping_validate_get_license();
                    if ($validation['type'] == 'free' && count($post_options['courier']) > 1) {
                        $error_update = true;
                        $error_message = 'Kurir hanya bisa dipilih satu.';
                    }

                    if (!$error_update) {
                        $current_options = aw_shipping_options();
                        $post_options = array_merge($current_options, $post_options);
                        update_option($this->opt_setting_key, $post_options);

                        $success_update = true;
                        $success_message = 'Settings saved.';
                    }
                }
            }

            $tab = (!empty($_GET['tab']) ? $_GET['tab'] : 'general');
            $plugin_data = get_plugin_data(aw_shipping_plugin_file());
            $data = aw_shipping_options();
            $license_code = $data['license'] ?? '';
            ?>
            <div id="agenwebsite_shipping-settings" class="wrap woocommerce">

                <?php if ($success_update) : ?>
                    <div id="setting-error-settings_updated" class="updated settings-error notice is-dismissible">
                        <p><strong><?php echo $success_message; ?></strong></p>
                        <button type="button" class="notice-dismiss"><span
                                    class="screen-reader-text">Dismiss this notice.</span></button>
                    </div>
                <?php endif; ?>

                <?php if ($error_update) : ?>
                    <div id="setting-error-settings_updated" class="notice notice-error is-dismissible">
                        <p><strong><?php echo $error_message; ?></strong></p>
                        <button type="button" class="notice-dismiss"><span
                                    class="screen-reader-text">Dismiss this notice.</span></button>
                    </div>
                <?php endif; ?>

                <div class="agenwebsite-head">
                    <div class="description">
                        <h1>AgenWebsite Shipping
                            <small><code>version <?php echo $plugin_data['Version']; ?></code></small></h1>
                        <p><?php echo $plugin_data['Description']; ?></p>
                    </div>

                    <div class="logo">
                        <a href="https://www.agenwebsite.com/" target="_blank">
                            <img alt="AgenWebsite" id="logo"
                                 src="<?php echo aw_shipping_plugin_url(); ?>/assets/images/logo.png"></a>
                    </div>

                    <?php if (!empty($license_code)) : ?>
                        <div id="agenwebsite-status" style="display:block;">
                            <table class="woocommerce_agenwebsite_status_table widefat is-large-screen"
                                   id="wc_agenwebsite_status" cellspacing="0">
                                <thead>
                                <tr>
                                    <th colspan="3">AgenWebsite Product Status</th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr>
                                    <td colspan="3" class="load_status">
                                        <img
                                                src="https://demo.agenwebsite.com/wp-content/plugins/agenwebsite-shipping-old/assets/images/progress.gif"/>
                                        <span>Connecting to AgenWebsite ...</span>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>

                        <script type="text/javascript">
                            jQuery(function ($) {
                                license_check_status();
                            });
                        </script>
                    <?php endif; ?>
                </div>

                <?php
                if (empty($license_code)) :
                    require_once aw_shipping_plugin_path() . '/views/settings/settings-license.php';
                else:
                    ?>
                    <div class="tab-wrapper">
                        <a class="nav-tab <?php echo($tab == 'general' ? 'nav-tab-active' : ''); ?>"
                           href="<?php echo admin_url('admin.php?page=agenwebsite_shipping&tab=general'); ?>">General</a>
                        <a class="nav-tab <?php echo($tab == 'license' ? 'nav-tab-active' : ''); ?>"
                           href="<?php echo admin_url('admin.php?page=agenwebsite_shipping&tab=license'); ?>">License</a>
                        <a class="nav-tab premium-version <?php echo($tab == 'international' ? 'nav-tab-active' : ''); ?>"
                           href="<?php echo admin_url('admin.php?page=agenwebsite_shipping&tab=international'); ?>">International
                            Shipping</a>
                        <a class="nav-tab premium-version <?php echo($tab == 'instant' ? 'nav-tab-active' : ''); ?>"
                           href="<?php echo admin_url('admin.php?page=agenwebsite_shipping&tab=instant'); ?>">Instant
                            Courier</a>
                        <a class="nav-tab premium-version <?php echo($tab == 'insurance' ? 'nav-tab-active' : ''); ?>"
                           href="<?php echo admin_url('admin.php?page=agenwebsite_shipping&tab=insurance'); ?>">Asuransi</a>
                        <a class="nav-tab premium-version <?php echo($tab == 'check_ongkir' ? 'nav-tab-active' : ''); ?>"
                           href="<?php echo admin_url('admin.php?page=agenwebsite_shipping&tab=check_ongkir'); ?>">Cek
                            Ongkir</a>
                        <a class="nav-tab premium-version <?php echo($tab == 'tracking' ? 'nav-tab-active' : ''); ?>"
                           href="<?php echo admin_url('admin.php?page=agenwebsite_shipping&tab=tracking'); ?>">Tracking</a>
                    </div>

                    <div class="agenwebsite-shipping-settings">
                        <?php
                        if ($tab === 'general') :
                            $options = $this->get_general_options('general');
                            require_once aw_shipping_plugin_path() . '/views/settings/settings-general.php';
                        elseif ($tab === 'license') :
                            $options = $this->get_general_options('license');
                            require_once aw_shipping_plugin_path() . '/views/settings/settings-license.php';
                        elseif ($tab === 'instant') :
                            $options = $this->get_general_options('instant');
                            $is_premium = true;
                            require_once aw_shipping_plugin_path() . '/views/settings/settings-general.php';
                        elseif ($tab === 'international') :
                            $options = $this->get_general_options('international');
                            $is_premium = true;
                            require_once aw_shipping_plugin_path() . '/views/settings/settings-general.php';
                        elseif ($tab === 'insurance') :
                            $options = $this->get_general_options('insurance');
                            $is_premium = true;
                            require_once aw_shipping_plugin_path() . '/views/settings/settings-general.php';
                        elseif ($tab === 'check_ongkir') :
                            $options = $this->get_general_options('check_ongkir');
                            $is_premium = true;
                            require_once aw_shipping_plugin_path() . '/views/settings/settings-general.php';
                        elseif ($tab === 'tracking') :
                            $options = $this->get_general_options('tracking');
                            $is_premium = true;
                            require_once aw_shipping_plugin_path() . '/views/settings/settings-general.php';
                        endif;
                        ?>
                    </div>
                <?php endif; ?>

                <style>
                    .nav-tab {
                        position: relative;
                    }

                    .premium-version:after {
                        content: "PRO";
                        position: absolute;
                        top: -10px;
                        right: -30px;
                        background: #2271b1;
                        color: #fff;
                        padding: 0 10px;
                        font-size: 10px;
                        line-height: 20px;
                        border-radius: 0 3px 0 0;
                        z-index: 99;
                    }
                </style>
            </div>
            <?php
        }

        /**
         * Get general options
         *
         * @access  public
         * @return  array   Options list
         * @since   1.0.0
         */
        function get_general_options($type = 'general')
        {
            $options = [];
            if ($type == 'general') {
                $validation = aw_shipping_validate_get_license();
                $options = [
                    'enable' => [
                        'id' => 'enable',
                        'title' => 'Aktifkan/Nonaktifkan',
                        'type' => 'checkbox',
                        'label' => 'Aktifkan AgenWebsite Shipping',
                        'default' => 'yes',
                    ],
                    'default_weight' => [
                        'id' => 'default_weight',
                        'title' => 'Berat Default (kg)',
                        'type' => 'number',
                        'default' => '1',
                        'description' => 'Berat default untuk produk yang tidak memiliki berat.',
                    ],
                    'enable_total_weight' => [
                        'id' => 'enable_total_weight',
                        'title' => 'Aktifkan total berat',
                        'type' => 'checkbox',
                        'label' => 'Tampilkan total berat di halaman tabel checkout.',
                        'default' => 'yes',
                    ],
                    'courier' => [
                        'id' => 'courier',
                        'title' => 'Aktifkan Kurir',
                        'type' => 'courier',
                        'default' => 'jne',
                        'description' => $validation['type'] == 'free' ? '<strong class="color-red">Free Version hanya bisa memilih 1 kurir</strong>' : 'Pilih Kurir berdasarkan kebutuhan Anda.'
                    ],
                    'courier_service' => [
                        'id' => 'courier_service',
                        'title' => 'Layanan Kurir',
                        'type' => 'courier_service',
                    ],
                ];
            } elseif ($type == 'instant') {
                $options = [
                    'instant_enable' => [
                        'id' => 'instant_enable',
                        'title' => 'Aktifkan Instant Courier',
                        'type' => 'checkbox',
                        'label' => 'Aktifkan instant courier',
                        'default' => 'no',
                    ],
                    'courier_instant' => [
                        'id' => 'courier_instant',
                        'title' => 'Aktifkan Kurir Instant',
                        'type' => 'courier_instant',
                        'default' => '',
                        'description' => 'Pilih Kurir berdasarkan kebutuhan Anda.'
                    ],
                    'courier_instant_service' => [
                        'id' => 'courier_instant_service',
                        'title' => 'Layanan Kurir',
                        'type' => 'courier_instant_service',
                    ],
                    'google_maps_api_key' => [
                        'id' => 'google_maps_api_key',
                        'title' => 'Google Maps API Key',
                        'type' => 'text',
                        'default' => '',
                        'description' => 'Masukkan Google Maps API Key untuk mendapatkan jarak dan durasi pengiriman. <span class="error-maps"></span>'
                    ],
                    'position_latitude' => [
                        'id' => 'position_latitude',
                        'title' => 'Latitude',
                        'type' => 'text',
                        'default' => '',
                        'description' => 'Drag and drop maps dibawah untuk mendapatkan latitude.'
                    ],
                    'position_longitude' => [
                        'id' => 'position_longitude',
                        'title' => 'Longitude',
                        'type' => 'text',
                        'default' => '',
                        'description' => 'Drag and drop maps dibawah untuk mendapatkan longitude.'
                    ],
                    'position_address' => [
                        'id' => 'position_address',
                        'title' => 'Alamat',
                        'type' => 'text',
                        'default' => '',
                        'description' => 'Alamat yang akan ditampilkan di maps.'
                    ],
                    'google_maps' => [
                        'id' => 'google_maps',
                        'title' => 'Google Maps',
                        'type' => 'google_maps'
                    ]
                ];
            } elseif ($type == 'international') {
                $options = [
                    'instant_enable' => [
                        'id' => 'instant_enable',
                        'title' => 'Aktifkan International Shipping',
                        'type' => 'checkbox',
                        'label' => 'Aktifkan international shipping',
                        'default' => 'no',
                    ],
                    'courier_international' => [
                        'id' => 'courier_international',
                        'title' => 'Aktifkan Kurir International',
                        'type' => 'courier_international',
                        'default' => '',
                        'description' => 'Pilih Kurir berdasarkan kebutuhan Anda.'
                    ],
                    'courier_international_service' => [
                        'id' => 'courier_international_service',
                        'title' => 'Layanan Kurir',
                        'type' => 'courier_international_service',
                    ],
                ];
            } elseif ($type == 'insurance') {
                $options = [
                    'insurance_enable' => [
                        'id' => 'insurance_enable',
                        'title' => 'Aktifkan Asuransi',
                        'type' => 'checkbox',
                        'label' => 'Aktifkan ke semua produk',
                        'default' => 'no',
                        'description' => 'Dengan mencentang ini, maka semua produk yang ada akan diasuransikan dan pengaturan di metapost akan diabaikan.',
                    ],
                    'insurance_label' => [
                        'id' => 'insurance_label',
                        'title' => 'Label Asuransi',
                        'type' => 'text',
                        'default' => 'Asuransikan produk ini seharga {harga} ?',
                        'description' => 'Teks ini akan muncul dihalaman produk yang diasuransikan. Gunakan <code>{harga}</code> untuk menampilkan harga asuransi.',
                    ],
                    'insurance_label_mandatory' => [
                        'id' => 'insurance_label_mandatory',
                        'title' => 'Label Asuransi Wajib',
                        'type' => 'text',
                        'default' => 'Produk ini di asuransikan seharga {harga}.',
                        'description' => 'Teks ini akan muncul dihalaman produk yang wajib diasuransikan. Gunakan <code>{harga}</code> untuk menampilkan harga asuransi.',
                    ],
                    'insurance_formula' => [
                        'id' => 'insurance_formula',
                        'title' => 'Formula Asuransi',
                        'type' => 'text',
                        'default' => '0.05',
                        'description' => 'Formula asuransi yang digunakan untuk menghitung harga asuransi. Misalnya, 0.05 berarti 5% dari harga produk.',
                    ],
                    'insurance_formula_plus' => [
                        'id' => 'insurance_formula_plus',
                        'title' => 'Penambahan Formula Asuransi',
                        'type' => 'text',
                        'default' => '5000',
                        'description' => 'Penambahan harga asuransi yang digunakan untuk menghitung harga asuransi. Misalnya, 5000 berarti ditambah 5.000 dari harga asuransi.',
                    ]
                ];
            } elseif ($type == 'check_ongkir') {
                $options = [
                    'check_ongkir_enable' => [
                        'id' => 'check_ongkir_enable',
                        'title' => 'Aktifkan Cek Ongkir',
                        'type' => 'checkbox',
                        'label' => 'Aktifkan cek ongkir di halaman produk.',
                        'default' => 'yes',
                    ],
                    'check_ongkir_label' => [
                        'id' => 'check_ongkir_label',
                        'title' => 'Label Cek Ongkir',
                        'type' => 'text',
                        'default' => 'Cek Ongkir',
                        'description' => 'Teks ini akan muncul dihalaman produk yang memiliki cek ongkir.',
                    ]
                ];
            } else if ($type == 'tracking') {
                $options = [
                    'tracking_button' => [
                        'id' => 'tracking_button',
                        'title' => 'Button Tracking',
                        'type' => 'text',
                        'default' => 'Lacak Pesanan',
                        'description' => 'Masukkan button teks yang kamu inginkan untuk pelacakan nomor resi agenwebsite.',
                    ],
                    'tracking_message' => [
                        'id' => 'tracking_message',
                        'title' => 'Pesan Tracking',
                        'type' => 'textarea',
                        'default' => 'Pesanan Anda dikirimkan melalui: <strong>[agenwebsite_tracking_title]</strong> <br/>Nomor resi untuk pesanan Anda: <strong>[agenwebsite_tracking_number]</strong>',
                        'description' => 'Deskripsi ditampilkan di bagian my-account, view order, dan email ketika order complete <br/><code>[agenwebsite_tracking_title]</code> = Judul AgenWebsite Tracking<br/><code>[agenwebsite_tracking_number]</code> = Menampilkan kode agenwebsite tracking<br/>',
                    ]
                ];
            }
            return $options;
        }
    }

    new AWShipping_Settings();

endif;