<?php
/**
 * AgenWebsite Shipping - Insurance Module
 *
 * @author AgenWebsite Shipping
 * @package AgenWebsite Shipping
 * @since 1.0.0
 */
if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

if (!class_exists('AWShipping_Insurance')) :

    class AWShipping_Insurance
    {
        public function __construct()
        {
            add_action('woocommerce_after_add_to_cart_button', array(&$this, 'asuransi_html'), 10);

            add_filter('woocommerce_add_cart_item_data', array(&$this, 'add_cart_item_data'), 10, 2);
            add_filter('woocommerce_get_cart_item_from_session', array(&$this, 'get_cart_item_from_session'), 10, 2);
            add_filter('woocommerce_get_item_data', array(&$this, 'get_item_data'), 10, 2);
            add_action('woocommerce_add_order_item_meta', array(&$this, 'add_order_item_meta'), 10, 2);
        }

        public function asuransi_is($post_id)
        {
            $options = aw_shipping_options();

            return ($options['insurance_enable'] ?? "no") == 'yes' ? true : false;
        }

        private function get_asuransi_price($product_price)
        {
            $options = aw_shipping_options();
            $formula = $options['insurance_formula'] ?? 0;
            $formula_plus = $options['insurance_formula_plus'] ?? 0;

            return ($product_price / 100 * $formula) + $formula_plus;
        }

        public function asuransi_html()
        {
            global $post;

            $options = aw_shipping_options();

            /** @var array $asuransi_is */
            $asuransi_is = $this->asuransi_is($post->ID);

            $product = new WC_Product($post->ID);
            $asuransi_price = wc_price($this->get_asuransi_price($product->get_price()));

            if ($asuransi_is && $asuransi_price > 0) {
                $message_required = $options['insurance_label_mandatory'];
                $message_required = str_replace('{harga}', $asuransi_price, $message_required);

                wc_get_template('agenwebsite-asuransi.php', array(
                    'message_agenwebsite_asuransi' => sprintf($message_required, $asuransi_price),
                ), sprintf('agenwebsite-shipping'), untrailingslashit(aw_shipping_plugin_path()) . '/templates/');
            }
        }

        public function add_cart_item_data($cart_item_meta, $product_id)
        {
            $asuransi_is = $this->asuransi_is($product_id);

            $product = new WC_Product($product_id);

            if ($asuransi_is) {
                $cart_item_meta['agenwebsite_asuransi'] = true;
                $cart_item_meta['agenwebsite_asuransi_price'] = $this->get_asuransi_price($product->get_price());
            }

            return $cart_item_meta;
        }

        public function get_cart_item_from_session($cart_item, $values)
        {
            if (!empty($values['agenwebsite_asuransi']) && !empty($values['agenwebsite_asuransi_price'])) {
                $cart_item['agenwebsite_asuransi'] = true;
                $total = $cart_item['agenwebsite_asuransi_price'] + ($cart_item['data']->get_price() * $cart_item['quantity']);
                $cart_item['data']->set_price($total);
            }

            return $cart_item;
        }

        public function get_item_data($item_data, $cart_item)
        {
            if (!empty($cart_item['agenwebsite_asuransi'])) {
                $price = $cart_item['agenwebsite_asuransi_price'] * $cart_item['quantity'];
                $item_data[] = array(
                    'name' => sprintf(__('Asuransi Pengiriman x %u ', 'agenwebsite-shipping'), $cart_item['quantity']),
                    'value' => wc_price($price),
                    'display' => wc_price($price)
                );
            }

            return $item_data;
        }

        public function add_cart_item($cart_item)
        {
            if (!empty($cart_item['agenwebsite_asuransi'])) {
                $cart_item['data']->set_price($cart_item['agenwebsite_asuransi_price']);
            }

            return $cart_item;
        }

        public function add_order_item_meta($item_id, $cart_item)
        {
            if (!empty($cart_item['agenwebsite_asuransi'])) {
                wc_add_order_item_meta($item_id, __('Asuransi Produk', 'agenwebsite-shipping'), wc_price($cart_item['agenwebsite_asuransi_price']));
            }
        }

    }

    new AWShipping_Insurance();
endif;