<?php
/**
 * AgenWebsite Shipping - WooCommerce Frontend
 *
 * @author AgenWebsite Shipping
 * @package AgenWebsite Shipping
 * @since 1.0.0
 */
if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

if (!class_exists('AWShippingInstantCourier')) :

    class AWShippingInstantCourier
    {

        public function __construct()
        {
            add_filter('woocommerce_checkout_fields', array($this, 'instant_checkout_fields'));
            add_action('woocommerce_checkout_update_order_meta', [$this, 'checkout_field_update_order_meta']);

            add_action('woocommerce_checkout_update_order_review', [$this, 'set_persitent_checkout']);

            add_action('wp_enqueue_scripts', [$this, 'enqueue_scripts'], 10);
            add_action('wp_head', [$this, 'head_maps']);
            add_action('wp_footer', [$this, 'footer_maps']);

            add_action('add_meta_boxes', [$this, 'woocommerce_instant_add_meta_box']);
        }

        public function instant_checkout_fields($fields)
        {
            $options = aw_shipping_options();

            $enable = $options['instant_enable'] ?? 'no';
            if ($enable == 'yes') {
                $checkout = WC()->checkout;
                $customer_id = WC()->session->get_customer_id();

                $customer_lat = (!empty($checkout->get_value('agenwebsite_billing_pinpoint')) ? $checkout->get_value('agenwebsite_billing_pinpoint') : WC()->session->get('agenwebsite_billing_pinpoint_' . $customer_id));

                $fields['billing']['agenwebsite_billing_pinpoint'] = array(
                    'label' => __('Koordinat Pinpoint Lokasi', 'woocommerce'),
                    'required' => false,
                    'class' => array('form-row-wide', 'address-field'),
                    'autocomplete' => 'address-level1',
                    'priority' => 45,
                    'placeholder' => 'Klik untuk memilih lokasi sesuai peta',
                    'default' => $customer_lat
                );
                $fields['shipping']['agenwebsite_shipping_pinpoint'] = array(
                    'label' => __('Koordinat Pinpoint Lokasi', 'woocommerce'),
                    'required' => false,
                    'class' => array('form-row-wide', 'address-field'),
                    'autocomplete' => 'address-level1',
                    'priority' => 45,
                    'placeholder' => 'Klik untuk memilih lokasi sesuai peta'
                );
            }
            return $fields;
        }

        public function checkout_field_update_order_meta($order_id)
        {
            parse_str($_POST['post_data'], $post_data);

            if (!empty($_POST['agenwebsite_billing_pinpoint'])) {
                update_post_meta($order_id, 'agenwebsite_billing_pinpoint', sanitize_text_field($_POST['agenwebsite_billing_pinpoint']));
            }
            if (!empty($_POST['agenwebsite_shipping_pinpoint'])) {
                update_post_meta($order_id, 'agenwebsite_shipping_pinpoint', sanitize_text_field($_POST['agenwebsite_shipping_pinpoint']));
            }
        }

        function set_persitent_checkout($posted_data)
        {
            parse_str($posted_data, $data);
            $customer_id = WC()->session->get_customer_id();

            WC()->session->set('agenwebsite_billing_pinpoint_' . $customer_id, $data['agenwebsite_billing_pinpoint'] ?? "");
        }

        function enqueue_scripts()
        {
            if (is_checkout()) {
                $options = aw_shipping_options();
                if (($options['instant_enable'] ?? 'no') != 'yes') return;

                wp_enqueue_style('aw-shipping-instant', aw_shipping_plugin_url() . '/assets/css/agenwebsite-shipping-instant-courier.css', array(), '1.0.0', 'all');
                wp_enqueue_script('aw-shipping-instant', aw_shipping_plugin_url() . '/assets/js/agenwebsite-shipping-instant-courier.js', array('jquery', 'select2'), '1.0.0', true);

                $localize = [
                    'ajax_url' => admin_url('admin-ajax.php'),
                    '_wpnonce' => wp_create_nonce('aw_shipping_nonce'),
                ];
                wp_localize_script('aw-shipping-instant', 'aw_shipping', $localize);

                $args_google_maps = array(
                    'key' => $options['google_maps_api_key'],
                    'callback' => 'initMap',
                    'libraries' => 'places',
                );
                wp_register_script('enqueue-maps-script', add_query_arg($args_google_maps, 'https://maps.googleapis.com/maps/api/js'), array('jquery'), '', true);
                wp_enqueue_script('enqueue-maps-script');
            }
        }

        public function head_maps()
        {
            if (is_checkout()) {
                $options = aw_shipping_options();
                if (($options['instant_enable'] ?? 'no') != 'yes') return;
                echo '<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0"/>';
            }
        }

        public function footer_maps()
        {
            $html = '';

            if (is_checkout()) {
                $options = aw_shipping_options();
                if (($options['instant_enable'] ?? 'no') != 'yes') return;

                $customer_id = WC()->session->get_customer_id();

                $current_latitude = !empty(WC()->session->get('agenwebsite_billing_pinpoint_' . $customer_id)) ? WC()->session->get('agenwebsite_billing_pinpoint_' . $customer_id) : '';
                $data = explode(',', $current_latitude);

                $default_latitude = !empty($data[0]) ? $data[0] : '-6.1753917';
                $default_longitude = !empty($data[1]) ? $data[1] : '106.8271533';

                $google_maps_api_key = (isset($options['google_maps_api_key']) ? $options['google_maps_api_key'] : '');

                if (!empty($google_maps_api_key)) {
                    ?>
                    $html .= '
                    <div id="modal_aw_instant_courier" class="modal-instant-courier-wrapper">
                        <div id="modal_aw_instant_courier_close" class="modal-instant-courier-center">
                            <div class="modal-instant-courier-content">
                                <span class="modal-instant-courier-close"></span>
                                <p class="instant-courier-pinpoint">Pinpoint Pengiriman</p>
                                <input id="pac-input" class="controls" type="text" placeholder="Search Box"
                                       onfocus="if(this.value == 'value') { this.value = ''; }">
                                <div id="instant_maps"></div>
                                <div id="button_pinpoint">
                                    <button id="button_pinpoint_instant_courier" type="button"
                                            class="button alt button-pinpoint-instant_courier">Pilih Titik
                                    </button>
                                    <img class="image-pinpoint"
                                         src="<?php echo aw_shipping_plugin_url(); ?>/assets/images/marker.png"
                                         height="52"
                                         width="37" alt="">
                                </div>
                            </div>
                        </div>
                    </div>';

                    $html .= '
                    <script>
                        var map;
                        var marker;
                        var geocoder;

                        // Initiate maps
                        function initMap() {
                            var myLatLng = {
                                lat: <?php echo $default_latitude; ?>,
                                lng: <?php echo $default_longitude; ?>};

                            // Convert element into maps
                            map = new google.maps.Map(document.getElementById("instant_maps"), {
                                center: myLatLng,
                                zoom: 15,
                                mapTypeControl: false,
                                fullscreenControl: false,
                                streetViewControl: false,
                                gestureHandling: "greedy"
                            });

                            // Trigger for enter
                            google.maps.event.trigger(input, "focus");
                            google.maps.event.trigger(input, "keydown", {keyCode: 13});

                            // Add geocoder for current lat long
                            geocoder = new google.maps.Geocoder;
                            addMarker(map, myLatLng);
                            geocodeLatLng(geocoder, map, myLatLng);

                            // Create the search box and link it to the UI element.
                            var input = document.getElementById("pac-input");
                            var autocomplete = new google.maps.places.Autocomplete(input);
                            autocomplete.setComponentRestrictions(
                                {"country": ["id"]});
                            // map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);

                            // Get device location
                            if (navigator.geolocation && myLatLng.lat == <?php echo $default_latitude; ?> && myLatLng.lng == <?php echo $default_longitude; ?>) {
                                navigator.geolocation.getCurrentPosition(function (position) {
                                    myLatLng = {
                                        lat: position.coords.latitude,
                                        lng: position.coords.longitude
                                    };
                                    map.setCenter(myLatLng);
                                    marker.setPosition(myLatLng);
                                    geocodeLatLng(geocoder, map, myLatLng);
                                }, function () {
                                    // User block device location
                                    marker.setPosition(myLatLng);
                                    geocodeLatLng(geocoder, map, myLatLng);
                                });
                            } else {
                                // Device doesnt have location
                                marker.setPosition(myLatLng);
                                geocodeLatLng(geocoder, map, myLatLng);
                            }

                            // Add event when google maps drag
                            window.google.maps.event.addListener(map, "drag", function (event) {
                                var position = marker.getPosition();
                                myLatLng = {
                                    lat: position.lat(),
                                    lng: position.lng()
                                };

                                marker.setPosition(map.getCenter());
                                geocodeLatLng(geocoder, map, myLatLng);
                            });

                            // Add event when user click searchbox autocomplete
                            autocomplete.addListener("place_changed", function () {
                                var place = autocomplete.getPlace();

                                if (!place.geometry) {
                                    // User entered the name of a Place that was not suggested and
                                    // pressed the Enter key, or the Place Details request failed.
                                    return;
                                }

                                // If the place has a geometry, then present it on a map.
                                myLatLng = {
                                    lat: place.geometry.location.lat(),
                                    lng: place.geometry.location.lng()
                                };

                                map.setCenter(place.geometry.location);
                                marker.setPosition(place.geometry.location);
                                geocodeLatLng(geocoder, map, myLatLng);
                            });

                            // Add device location button
                            addYourLocationButton(map, marker);

                            // Add default value address from
                            if (myLatLng.lat != <?php echo $default_latitude; ?> && myLatLng.lng != <?php echo $default_longitude; ?>) {
                                document.getElementById("label_address").value = "Loading address...";

                                var position = marker.getPosition();
                                myLatLng = {
                                    lat: position.lat(),
                                    lng: position.lng()
                                };
                                setLatLng(myLatLng);
                                setgeocodeLatLng(geocoder, map, myLatLng);
                            }
                        }

                        // When API Key error
                        function gm_authFailure() {
                            document.getElementById("woocommerce_instant_courier_google_maps_api_key").classList.add("alert");
                            document.getElementsByClassName("error-maps")[0].innerHTML = "API Key Anda salah. <a href=\"#\" target=\"_blank\">Baca Cara Mendapatkan dan Mengaktifkan Google Maps API Key</a>";
                        };

                        function addYourLocationButton(map, marker) {
                            var controlDiv = document.createElement("div");

                            var firstChild = document.createElement("button");
                            firstChild.style.backgroundColor = "#fff";
                            firstChild.style.border = "none";
                            firstChild.style.outline = "none";
                            firstChild.style.width = "28px";
                            firstChild.style.height = "28px";
                            firstChild.style.borderRadius = "2px";
                            firstChild.style.boxShadow = "0 1px 4px rgba(0,0,0,0.3)";
                            firstChild.style.cursor = "pointer";
                            firstChild.style.marginRight = "10px";
                            firstChild.style.padding = "0px";
                            firstChild.type = "button";
                            firstChild.title = "Your Location";
                            controlDiv.appendChild(firstChild);

                            var secondChild = document.createElement("div");
                            secondChild.style.margin = "5px";
                            secondChild.style.width = "18px";
                            secondChild.style.height = "18px";
                            secondChild.style.backgroundImage = "url(https://maps.gstatic.com/tactile/mylocation/mylocation-sprite-1x.png)";
                            secondChild.style.backgroundSize = "180px 18px";
                            secondChild.style.backgroundPosition = "0px 0px";
                            secondChild.style.backgroundRepeat = "no-repeat";
                            secondChild.id = "you_location_img";
                            firstChild.appendChild(secondChild);

                            google.maps.event.addListener(map, "dragend", function () {
                                jQuery("#you_location_img").css("background-position", "0px 0px");
                            });

                            firstChild.addEventListener("click", function () {
                                var imgX = "0";
                                var animationInterval = setInterval(function () {
                                    if (imgX == "-18") imgX = "0";
                                    else imgX = "-18";
                                    jQuery("#you_location_img").css("background-position", imgX + "px 0px");
                                }, 500);
                                if (navigator.geolocation) {
                                    navigator.geolocation.getCurrentPosition(function (position) {
                                        var myLatLng = {
                                            lat: position.coords.latitude,
                                            lng: position.coords.longitude
                                        };
                                        map.setCenter(myLatLng);

                                        marker.setPosition(myLatLng);

                                        geocodeLatLng(geocoder, map, myLatLng);

                                        clearInterval(animationInterval);
                                        jQuery("#you_location_img").css("background-position", "-144px 0px");
                                    });
                                } else {
                                    clearInterval(animationInterval);
                                    jQuery("#you_location_img").css("background-position", "0px 0px");
                                }
                            });

                            controlDiv.index = 1;
                            map.controls[google.maps.ControlPosition.RIGHT_BOTTOM].push(controlDiv);
                        }

                        // Add marker
                        function addMarker(map, latLng) {
                            marker = new google.maps.Marker({
                                position: latLng,
                                map: map,
                                title: "Your Location",
                                visible: false
                            });
                        }

                        // Set latitude and longitude into element value
                        function setLatLng(latlng) {
                            document.getElementById("agenwebsite_billing_pinpoint").value = `${latlng.lat},${latlng.lng}`;
                        }

                        // Get location name from latitude longitude
                        function geocodeLatLng(geocoder, map, latlng) {
                            geocoder.geocode({"location": latlng}, function (results, status) {
                                if (status === "OK") {
                                    if (results[0]) {
                                        var address = results[0].formatted_address;

                                        document.getElementById("pac-input").value = address;
                                    } else {
                                        // Map Not Found
                                    }
                                } else {
                                    // Geocoder error
                                }
                            });
                        }

                        // Set geocode name from latitude longitude into element
                        function setgeocodeLatLng(geocoder, map, latlng) {
                            geocoder.geocode({"location": latlng}, function (results, status) {
                                if (status === "OK") {
                                    if (results[0]) {
                                        var address = results[0].formatted_address;

                                        document.getElementById("billing_address_1").value = address;
                                    } else {
                                        // Map Not Found
                                    }
                                } else {
                                    // Geocoder error
                                }
                            });
                        }

                        // When user click enter
                        function selectFirstResult() {
                            var firstResult = jQuery(".pac-container .pac-item:first").text();

                            var geocoder = new google.maps.Geocoder();
                            geocoder.geocode({"address": firstResult}, function (results, status) {
                                if (status == google.maps.GeocoderStatus.OK) {
                                    var lat = results[0].geometry.location.lat(),
                                        lng = results[0].geometry.location.lng(),
                                        placeName = results[0].address_components[0].long_name,
                                        latlng = new google.maps.LatLng(lat, lng);

                                    myLatLng = {
                                        lat: lat,
                                        lng: lng
                                    };

                                    map.setCenter(myLatLng);
                                    marker.setPosition(myLatLng);

                                    geocodeLatLng(geocoder, map, myLatLng);
                                }
                            });
                        }

                        function updateDataCity() {
                            var position = marker.getPosition();
                            myLatLng = `${position.lat()},${position.lng()}`;

                            jQuery.ajax({
                                url: aw_shipping.ajax_url,
                                type: "POST",
                                data: {
                                    action: "agenwebsite_shipping_search_data",
                                    nonce: aw_shipping._wpnonce,
                                    latlng: myLatLng
                                },
                                success: function (response) {
                                    if (response.data) {
                                        var data = response.data[0];
                                        var province = data.province;
                                        var city = data.city;
                                        var district = data.district;
                                        var postcode = data.zipcode;

                                        const value = `${province}, ${city}, ${district}`;
                                        jQuery('#billing_postcode').val(postcode);

                                        const options = '<option selected value="' + value + '">' + value + '</option>';
                                        jQuery('#agenwebsite_billing_city').append(options).trigger('change');
                                    }
                                }
                            })

                        }

                        // Using jQuery
                        jQuery(document).ready(function ($) {
                            jQuery("#agenwebsite_billing_pinpoint").attr("readonly", "readonly");

                            $("#pac-input").focus(function () {
                                defaultText = $(this).val();
                                $(this).val("");
                            });

                            $("#pac-input").blur(function () {
                                $(this).val(defaultText);
                            });

                            // When user press enter
                            $("#pac-input").keydown(function (e) {
                                if (e.keyCode == 13) {
                                    selectFirstResult();
                                    e.preventDefault();
                                    return false;
                                }
                            });

                            const appendLabelAddress = `<span id="label_address"></span>`;
                            $("#agenwebsite_billing_pinpoint_field").append(appendLabelAddress);

                            // When user click pin maps
                            $("#button_pinpoint_instant_courier").click(function () {
                                $("#modal_aw_instant_courier").fadeOut();
                                $("body").removeClass("modal-open");
                                $("#woocommerce_instant_courier_from_address_field").removeClass("display-none");

                                var position = marker.getPosition();
                                myLatLng = {
                                    lat: position.lat(),
                                    lng: position.lng()
                                };
                                setLatLng(myLatLng);
                                setgeocodeLatLng(geocoder, map, myLatLng);
                                updateDataCity();

                                // trigger update woocommerce checkout
                                $("body").trigger("update_checkout");

                                return false;
                            });

                            $("#agenwebsite_billing_pinpoint").click(function () {
                                $("#modal_aw_instant_courier").fadeIn();
                                $("body").addClass("modal-open");
                                return false;
                            });

                            $(".modal-instant-courier-close").click(function () {
                                $("#modal_aw_instant_courier").fadeOut();
                                $("body").removeClass("modal-open");
                                return false;
                            });

                            var modal = document.getElementById("modal_aw_instant_courier_close");

                            window.onclick = function (event) {
                                if (event.target == modal) {
                                    $("#modal_aw_instant_courier").fadeOut();
                                    $("body").removeClass("modal-open");
                                    return false;
                                }
                            };
                        });
                    </script>';
                    <?php
                }

            }

            echo $html;
        }

        function woocommerce_instant_add_meta_box($post_type)
        {
            $options = aw_shipping_options();
            if (($options['instant_enable'] ?? 'no') != 'yes') return false;

            global $post;

            //limit meta box to order type only
            $post_order_type = array('shop_order');

            if (!in_array($post_type, $post_order_type)) return false;

            add_meta_box(
                'agenwebsite-shipping-instant',
                __('AgenWebsite Shipping Instant', 'agenwebsite-shipping'),
                array(&$this, 'render_meta_box'),
                $post_type,
                'side',
                'high'
            );

            return true;
        }

        public function render_meta_box($post)
        {
            $order_id = $post->ID;
            $order = wc_get_order($post->ID);

            $order_shipping_methods = $order->get_shipping_methods();
            $shipping_method = @array_shift($order_shipping_methods);
            $courier = $shipping_method->get_meta('courier');

            $current_longlat = get_post_meta($order_id, 'agenwebsite_billing_pinpoint', true);
            if (!$current_longlat) return;

            $data = explode(',', $current_longlat);
            $default_latitude = !empty($data[0]) ? $data[0] : '';
            $default_longitude = !empty($data[1]) ? $data[1] : '';

            $options = aw_shipping_options();
            $api_key = $options['google_maps_api_key'] ?? '';
            $store_latitude = $options['position_latitude'];
            $store_longitude = $options['position_longitude'];
            ?>
            <p class="agenwebsite-distance">Distance : <span id="agenwebsite-distance-value">Loading distance...</span>
            </p>
            <p class="agenwebsite-address"><span id="agenwebsite-address"></span></p>

            <div id="maps" style="width: 100%; height: 400px"></div>

            <script>
                var map;
                var marker;
                var geocoder;

                // Initiate maps
                function initMap() {
                    var directionsService = new google.maps.DirectionsService();
                    var directionsDisplay = new google.maps.DirectionsRenderer();
                    var myLatLng = {lat: <?php echo $default_latitude; ?>, lng: <?php echo $default_longitude; ?>};
                    var storeLatLng = {lat: <?php echo $store_latitude; ?>, lng: <?php echo $store_longitude; ?>};

                    // Convert element into maps
                    map = new google.maps.Map(document.getElementById("maps"), {
                        center: myLatLng,
                        zoom: 15,
                        mapTypeControl: false,
                        fullscreenControl: false,
                        streetViewControl: false
                    });
                    directionsDisplay.setMap(map);

                    // Start driving
                    var request = {
                        origin: storeLatLng,
                        destination: myLatLng,
                        travelMode: "DRIVING",
                        avoidTolls: true
                    };
                    directionsService.route(request, function (result, status) {
                        if (status == "OK") {
                            directionsDisplay.setDirections(result);

                            // Add delivery estimate
                            var totalDistance = 0;
                            var totalDuration = 0;
                            var legs = result.routes[0].legs;
                            for (var i = 0; i < legs.length; ++i) {
                                totalDistance += legs[i].distance.value;
                                totalDuration += legs[i].duration.value;
                            }

                            // convert to km
                            totalDistance = (totalDistance / 1000).toFixed(1);

                            document.getElementById("agenwebsite-distance-value").innerHTML = totalDistance + " km";
                        }
                    });

                    geocoder = new google.maps.Geocoder;

                    geocoder.geocode({"location": myLatLng}, function (results, status) {
                        if (status === "OK") {
                            if (results[0]) {
                                var address = results[0].formatted_address;

                                document.getElementById("agenwebsite-address").innerHTML = address;
                            } else {
                                // Map Not Found
                            }
                        } else {
                            // Geocoder error
                        }
                    });
                }

                // Add marker
                function addMarker(map, latLng) {
                    marker = new google.maps.Marker({
                        position: latLng,
                        map: map,
                        title: "Your Location"
                    });
                }
            </script>

            <script src="https://maps.googleapis.com/maps/api/js?key=<?php echo $api_key; ?>&amp;callback=initMap&amp;libraries=places&amp;ver=6.7.1"
                    id="enqueue-maps-script-js"></script>
            <?php
        }
    }

    new AWShippingInstantCourier();
endif;