<?php
/**
 * AgenWebsite Shipping - Check Ongkir Module
 *
 * @author AgenWebsite Shipping
 * @package AgenWebsite Shipping
 * @since 1.0.0
 */
if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

if (!class_exists('AWShipping_CheckOngkir')) :

    class AWShipping_CheckOngkir
    {
        public function __construct()
        {
            add_filter('woocommerce_product_tabs', array(&$this, 'add_product_tabs'));
            add_action('wp_enqueue_scripts', [$this, 'enqueue_scripts'], 10);
        }

        public function weight_product()
        {
            global $post;

            $shipping_settings = aw_shipping_options();
            $default_weight = $shipping_settings['default_weight'];

            $weight_product = get_post_meta($post->ID, '_weight', TRUE);
            $woo_weight_unit = get_option('woocommerce_weight_unit');

            $weight_unit = $woo_weight_unit;
            if (empty($weight_product)) {
                $weight_product = $default_weight;
                if ($woo_weight_unit == 'g')
                    $weight_unit = 'kg';
            } else {
                $weight_unit = $woo_weight_unit;
                if ($woo_weight_unit == 'g') {
                    $weight_product = $weight_product / 1000;
                    $weight_unit = 'kg';
                }
            }

            $weight['product'] = $weight_product;
            $weight['unit'] = $weight_unit;

            return $weight;
        }

        public function add_product_tabs($tabs)
        {
            $options = aw_shipping_options();
            $key_tab_title = 'agenwebsite_check_ongkir_tab_title';
            $title = $options['agenwebsite_check_ongkir_tab_title'] ?? 'Cek Ongkir';

            $tabs['cekongkir'] = array(
                'title' => $title,
                'priority' => 50,
                'callback' => array(&$this, 'product_tabs_panel_content'),
            );

            return $tabs;
        }

        public function product_tabs_panel_content()
        {
            wc_get_template('checkongkir/tabs.php', array(
                'weight' => $this->weight_product()
            ), 'agenwebsite-shipping', aw_shipping_plugin_path() . '/templates/');
        }

        public function enqueue_scripts()
        {
            if (is_product()) {
                wp_enqueue_style('aw-shipping', aw_shipping_plugin_url() . '/assets/css/agenwebsite-shipping-check-ongkir.css', array('select2'), '1.0.0', 'all');
                wp_enqueue_script('aw-shipping', aw_shipping_plugin_url() . '/assets/js/agenwebsite-shipping-check-ongkir.js', array('jquery', 'select2'), '1.0.0', true);

                $localize = [
                    'ajax_url' => admin_url('admin-ajax.php'),
                    '_wpnonce' => wp_create_nonce('aw_shipping_nonce'),
                ];
                wp_localize_script('aw-shipping', 'aw_shipping', $localize);
            }
        }
    }

    new AWShipping_CheckOngkir();

endif;