<?php
/**
 * AgenWebsite Shipping Settings
 *
 * @author AgenWebsite Shipping
 * @package AgenWebsite Shipping
 * @since 1.0.0
 */
if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

if (!class_exists('AWShipping_Ajax')):

    class AWShipping_Ajax
    {

        /* @var string */
        private static $nonce_admin = 'aw_shipping_nonce';

        /**
         * Constructor
         *
         * @return void
         * @since 1.0.0
         */
        public function __construct()
        {
            // ajax_event => nopriv
            $ajax_event_loop = array(
                'license_status' => false,
                'search_data' => true,
                'checkongkir_get_harga' => true,
                'tracking' => true,
            );
            foreach ($ajax_event_loop as $ajax_event => $nopriv) {
                add_action('wp_ajax_agenwebsite_shipping_' . $ajax_event, array(__CLASS__, $ajax_event));
                if ($nopriv) {
                    add_action('wp_ajax_nopriv_agenwebsite_shipping_' . $ajax_event, array(__CLASS__, $ajax_event));
                }
            }
        }

        public static function license_status()
        {
            check_ajax_referer(self::$nonce_admin, 'nonce');
            $output = array(
                'status' => 'error',
                'message' => 'Invalid request'
            );

            $options = aw_shipping_options();
            $license = $options['license'] ?? '';

            if ($license) {
                $starttime = microtime(true);

                $api = new AWShipping_Api();

                $body = [
                    'license' => $license
                ];

                $response = $api->remote_post('license', [], $body);

                $stoptime = microtime(true);
                $response_access = floor(($stoptime - $starttime) * 1000);
                $result['result']['response_access_time'] = $response_access . "ms";

                $data = [
                    'message' => $response['message'],
                    'success' => $response['status'] == 'success' ? true : false,
                    'result' => $response['result']
                ];

                ob_start();
                require_once aw_shipping_plugin_path() . '/views/settings/license-product-status.php';
                $output['message'] = ob_get_clean();

                $output['status'] = 'success';
            }

            wp_send_json($output);
            wp_die();
        }

        public static function search_data()
        {
            check_ajax_referer(self::$nonce_admin, 'nonce');
            $output = array(
                'status' => 'error',
                'message' => 'Terjadi kesalahan saat mengambil data silahkan coba lagi'
            );


            $options = aw_shipping_options();
            $license = $options['license'] ?? '';

            if ($license) {
                $starttime = microtime(true);

                $api = new AWShipping_Api();
                $body = [
                    'keyword' => sanitize_text_field($_POST['q']['term']),
                    'latlng' => sanitize_text_field($_POST['latlng']),
                ];
                $response = $api->remote_post('search_data', [], $body);
                if ($response['status'] == 'success') {
                    $output['status'] = 'success';
                    $output['data'] = $response['result'];
                    $output['message'] = 'Data berhasil diambil';
                }
            }

            wp_send_json($output);
            wp_die();
        }

        public static function checkongkir_get_harga()
        {
            check_ajax_referer(self::$nonce_admin, 'nonce');

            $options = aw_shipping_options();
            $tujuan['weight'] = $_REQUEST['weight'];
            $tujuan['weight_unit'] = get_option('woocommerce_weight_unit');

            $data_split = explode(', ', $_REQUEST['city']);

            $tujuan['provinsi'] = $data_split[0];
            $tujuan['kota'] = $data_split[1];
            $tujuan['kecamatan'] = $data_split[2];
            $tujuan['kodepos'] = $_POST['agenwebsite_billing_postcode'] ?? '';

            $cost = aw_shipping_get_costs($tujuan['provinsi'], $tujuan['kota'], $tujuan['kecamatan'], $tujuan['kodepos'], $tujuan['weight'], $options['courier']);

            $cekongkir['tujuan'] = $tujuan;
            $cekongkir['layanan'] = $cost;
            $cekongkir['id'] = ($_POST['type'] == 'widget') ? 'widget' : 'shortcode';

            $template_path = 'checkongkir/tabs-result.php';

            ob_start();

            wc_get_template($template_path, $cekongkir, 'agenwebsite-shipping', untrailingslashit(aw_shipping_plugin_path()) . '/templates/');

            $result = ob_get_clean();

            wp_send_json([
                'html' => $result
            ]);

            wp_die();
        }

        public static function tracking()
        {
            check_ajax_referer(self::$nonce_admin, 'nonce');

            $output = array(
                'status' => 'error',
                'message' => 'Invalid request'
            );

            $options = aw_shipping_options();
            $license = $options['license'] ?? '';

            if ($license) {
                $api = new AWShipping_Api();

                $order_id = sanitize_text_field($_POST['order_id']);
                $awb = get_post_meta($order_id, '_woocommerce_agenwebsite_tracking_number', true);
                $courier = get_post_meta($order_id, '_woocommerce_agenwebsite_tracking_courier', true);

                if(empty($awb) || empty($courier)){
                    wp_die();
                }

                $body = [
                    'awb' => $awb,
                    'courier' => $courier
                ];

                $response = $api->remote_post('tracking', [], $body);

                $data = [
                    'message' => $response['message'],
                    'success' => $response['status'] == 'success' ? true : false,
                    'result' => $response['result']
                ];

                $header = $response['result']['header'] ?? [];
                $tracking =  $response['result']['history'] ?? [];

                ob_start();
                require_once aw_shipping_plugin_path() . '/templates/tracking/agenwebsite-tracking-result.php';
                $output['message'] = ob_get_clean();

                $output['status'] = 'success';
            }

            wp_send_json($output);
            wp_die();
        }
    }

    new AWShipping_Ajax();
endif;
