jQuery(function ($) {
    if (typeof aw_shipping === 'undefined') {
        return false;
    }

    const aw_country_select_params = {"countries": "{\"ID\":{\"AC\":\"Nanggroe Aceh Darussalam\",\"SU\":\"Sumatera Utara\",\"SB\":\"Sumatera Barat\",\"RI\":\"Riau\",\"KR\":\"Kepulauan Riau\",\"JA\":\"Jambi\",\"SS\":\"Sumatera Selatan\",\"BB\":\"Bangka Belitung\",\"BE\":\"Bengkulu\",\"LA\":\"Lampung\",\"JK\":\"DKI Jakarta\",\"JB\":\"Jawa Barat\",\"BT\":\"Banten\",\"JT\":\"Jawa Tengah\",\"JI\":\"Jawa Timur\",\"YO\":\"Daerah Istimewa Yogyakarta\",\"BA\":\"Bali\",\"NB\":\"Nusa Tenggara Barat\",\"NT\":\"Nusa Tenggara Timur\",\"KB\":\"Kalimantan Barat\",\"KT\":\"Kalimantan Tengah\",\"KI\":\"Kalimantan Timur\",\"KS\":\"Kalimantan Selatan\",\"KU\":\"Kalimantan Utara\",\"SA\":\"Sulawesi Utara\",\"ST\":\"Sulawesi Tengah\",\"SG\":\"Sulawesi Tenggara\",\"SR\":\"Sulawesi Barat\",\"SN\":\"Sulawesi Selatan\",\"GO\":\"Gorontalo\",\"MA\":\"Maluku\",\"MU\":\"Maluku Utara\",\"PA\":\"Papua\",\"PB\":\"Papua Barat\"}}"};

    $('#billing_country').change(function () {
        const value = $(this).val();
        if (value !== 'ID') {
            $('#agenwebsite_billing_city_field').addClass('agenwebsite-hide');
            $('#billing_city_field').removeClass('agenwebsite-hide');
            $('#billing_state_field').removeClass('agenwebsite-hide');
        } else {
            $('#agenwebsite_billing_city_field').removeClass('agenwebsite-hide');
            $('#billing_city_field').addClass('agenwebsite-hide');
            $('#billing_state_field').addClass('agenwebsite-hide');
        }
    });

    $('#shipping_country').change(function () {
        const value = $(this).val();
        if (value !== 'ID') {
            $('#agenwebsite_shipping_city_field').addClass('agenwebsite-hide');
            $('#shipping_city_field').removeClass('agenwebsite-hide');
            $('#shipping_state_field').removeClass('agenwebsite-hide');
        } else {
            $('#agenwebsite_shipping_city_field').removeClass('agenwebsite-hide');
            $('#shipping_city_field').addClass('agenwebsite-hide');
            $('#shipping_state_field').addClass('agenwebsite-hide');
        }
    });

    function initAWFields() {
        if ($('#agenwebsite_billing_city').is('input')) {
            var countries = JSON.parse(aw_country_select_params['countries'])["ID"],
                provinceValue = $('#billing_state').val(),
                cityValue = $('#billing_city').val().split(","),
                currentValue = countries[provinceValue] + ", " + cityValue[0] + ", " + cityValue[1];

            $('#agenwebsite_billing_city').replaceWith($('<select />').attr({
                'name': $('#agenwebsite_billing_city').attr("id"),
                'id': $('#agenwebsite_billing_city').attr("id"),
                'placeholder': $('#agenwebsite_billing_city').attr("placeholder")
            }).addClass('city_select'));

            if (provinceValue && cityValue[0] && cityValue[1])
                $('#agenwebsite_billing_city').html('<option value="' + currentValue + '">' + currentValue + '</option>');


            $('#agenwebsite_billing_city').select2({
                minimumInputLength: 3,
                placeholder: 'Ketik nama provinsi atau kota atau kecamatan',
                ajax: {
                    url: aw_shipping.ajax_url,
                    type: 'POST',
                    dataType: 'json',
                    delay: 500,
                    cache: true,
                    data: function (term, page) {
                        return {
                            q: term,
                            page: page,
                            action: 'agenwebsite_shipping_search_data',
                            _wpnonce: aw_shipping._wpnonce
                        };
                    },
                    processResults: function (response) {
                        var terms = [];
                        const data = response.data;
                        if (data) {
                            for (let line of data) {
                                const text = `${line.province}, ${line.city}, ${line.district}`;
                                terms.push({
                                    id: text,
                                    text: text
                                });
                            }
                        }
                        return {
                            results: terms
                        };
                    }
                }
            });

            $('#billing_city_field, #billing_state_field').addClass('agenwebsite-hide');

            $('#agenwebsite_billing_city').change(function () {
                var val = $(this).val().split(','),
                    provinsi = val[0].trim(),
                    kota = val[1].trim(),
                    kecamatan = val[2].trim();

                var provinsiKode = "";
                var countries = JSON.parse(aw_country_select_params['countries'])["ID"];
                for (var i in countries) {
                    if (countries[i] === provinsi) {
                        provinsiKode = i;
                    }
                }
                $('#billing_state').val(provinsiKode).trigger('change');
                $('#billing_city').val(`${kota}, ${kecamatan}`).trigger('change');

                $('#billing_city').removeAttr('readonly');
            });
        }

        if ($('#agenwebsite_shipping_city').is('input')) {
            const city = $('#shipping_city').val() ?? $('#shipping-city').val();
            var countries = JSON.parse(aw_country_select_params['countries'])["ID"],
                provinceValue = $('#shipping_state').val(),
                cityValue = city.split(","),
                currentValue = countries[provinceValue] + ", " + cityValue[0] + ", " + cityValue[1];

            $('#agenwebsite_shipping_city').replaceWith($('<select />').attr({
                'name': $('#agenwebsite_shipping_city').attr("id"),
                'id': $('#agenwebsite_shipping_city').attr("id"),
                'placeholder': $('#agenwebsite_shipping_city').attr("placeholder"),
                'class': 'wc-blocks-components-select__select'
            }).addClass('city_select'));

            if (provinceValue && cityValue[0] && cityValue[1])
                $('#agenwebsite_shipping_city').html('<option value="' + currentValue + '">' + currentValue + '</option>');


            $('#agenwebsite_shipping_city').select2({
                minimumInputLength: 3,
                placeholder: 'Ketik nama provinsi atau kota atau kecamatan',
                ajax: {
                    url: aw_shipping.ajax_url,
                    type: 'POST',
                    dataType: 'json',
                    delay: 500,
                    cache: true,
                    data: function (term, page) {
                        return {
                            q: term,
                            page: page,
                            action: 'agenwebsite_shipping_search_data',
                            _wpnonce: aw_shipping._wpnonce
                        };
                    },
                    processResults: function (response) {
                        var terms = [];
                        const data = response.data;
                        if (data) {
                            for (let line of data) {
                                const text = `${line.province}, ${line.city}, ${line.district}`;
                                terms.push({
                                    id: text,
                                    text: text
                                });
                            }
                        }
                        return {
                            results: terms
                        };
                    }
                }
            });

            $('#shipping_city_field, #shipping_state_field').addClass('agenwebsite-hide');

            $('#agenwebsite_shipping_city').change(function () {
                var val = $(this).val().split(','),
                    provinsi = val[0].trim(),
                    kota = val[1].trim(),
                    kecamatan = val[2].trim();

                var provinsiKode = "";
                var countries = JSON.parse(aw_country_select_params['countries'])["ID"];
                for (var i in countries) {
                    if (countries[i] === provinsi) {
                        provinsiKode = i;
                    }
                }
                $('#shipping_state').val(provinsiKode).trigger('change');
                $('#shipping_city').val(`${kota}, ${kecamatan}`).trigger('change');

                $('#shipping_city').removeAttr('readonly');
            });
        }


        const countryBilling = $('#billing_country').val();
        if (countryBilling !== 'ID') {
            $('#agenwebsite_billing_city_field').addClass('agenwebsite-hide');
            $('#billing_city_field').removeClass('agenwebsite-hide');
            $('#billing_state_field').removeClass('agenwebsite-hide');
        }

        const countryShipping = $('#shipping_country').val();
        if (countryShipping !== 'ID') {
            $('#agenwebsite_shipping_city_field').addClass('agenwebsite-hide');
            $('#shipping_city_field').removeClass('agenwebsite-hide');
            $('#shipping_state_field').removeClass('agenwebsite-hide');
        }
    }

    initAWFields();

    if ($('body').hasClass('woocommerce-uses-block-theme')) {
        const waitForElement = setInterval(function () {
            if ($('.wp-block-woocommerce-checkout').length) {
                clearInterval(waitForElement);

                $('.wp-block-woocommerce-checkout').before(aw_shipping.woo_blocks_warning_message)
            }
        }, 100);
    } else {
        initAWFields();
    }
});