jQuery(function ($) {
    if (typeof aw_shipping === 'undefined') {
        return false;
    }

    $('#agenwebsite-tracking-button').on('click', function (e) {
        e.preventDefault();
        var order_id = $('#agenwebsite-tracking-number').val();

        $('#agenwebsite-tracking-result').css('opacity', '0.5');

        $.ajax({
            url: aw_shipping.ajax_url,
            type: 'POST',
            data: {
                action: 'agenwebsite_shipping_tracking',
                order_id: order_id,
                _wpnonce: aw_shipping._wpnonce
            },
            beforeSend: function () {
                $('#agenwebsite-tracking-button').attr('disabled', 'disabled').css('opacity', '0.5');
            },
            success: function (response) {
                $('#agenwebsite-tracking-result').css('opacity', '1');
                $('#agenwebsite-tracking-button').removeAttr('disabled').css('opacity', '1').remove();
                if (response.success) {
                    $('#agenwebsite-tracking-result').html(response.html).show();
                } else {
                    $('#agenwebsite-tracking-result').html(response.message).show();
                }
            },
            error: function () {
                $('#agenwebsite-tracking-result').css('opacity', '1');
                $('#agenwebsite-tracking-button').removeAttr('disabled').css('opacity', '1');
                $('#agenwebsite-tracking-result').html('Terjadi kesalahan silahkan coba kembali.').show();
            }
        });
    });

    $(document).ready(function () {
        $('#agenwebsite-tracking-button').trigger('click');
    });
});