jQuery(function ($) {
    if (typeof aw_shipping === 'undefined') {
        return false;
    }

    if ($('#agenwebsite_billing_city').is('select')) {
        $('#agenwebsite_billing_city').select2({
            width: '100%',
            placeholder: "Masukkan nama kota atau kecamatan",
            minimumInputLength: 3,
            ajax: {
                url: aw_shipping.ajax_url,
                type: 'POST',
                dataType: 'json',
                delay: 500,
                cache: true,
                data: function (term, page) {
                    return {
                        q: term,
                        page: page,
                        action: 'agenwebsite_shipping_search_data',
                        _wpnonce: aw_shipping._wpnonce
                    };
                },
                processResults: function (response) {
                    var terms = [];
                    const data = response.data;
                    if (data) {
                        for (let line of data) {
                            const text = `${line.province}, ${line.city}, ${line.district}`;
                            terms.push({
                                id: text,
                                text: text
                            });
                        }
                    }
                    return {
                        results: terms
                    };
                }
            }
        });

        $('#agenwebsite_billing_city').change(function () {
            $('.agenwebsite_shipping_check_ongkir_tab').addClass('agenwebsite_shipping_check_ongkir_tab_loader');
            $.ajax({
                url: aw_shipping.ajax_url,
                type: 'POST',
                dataType: 'json',
                data: {
                    action: 'agenwebsite_shipping_checkongkir_get_harga',
                    _wpnonce: aw_shipping._wpnonce,
                    city: $('#agenwebsite_billing_city').val(),
                    weight: $('#agenwebsite_weight').val(),
                },
                success: function (response) {
                    $('#agenwebsite_shipping_check_ongkir_tab_result').html(response.html).show();

                    $('.agenwebsite_shipping_check_ongkir_tab').removeClass('agenwebsite_shipping_check_ongkir_tab_loader');
                }
            })
        });
    }
});