jQuery(function ($) {
    if (typeof aw_shipping === 'undefined') {
        return false;
    }

    $('#activation_button').on('click', function (e) {
        if (!confirm('Apakah kamu yakin untuk menonaktifkan license ini ?')) {
            return false;
        }
    });

    $('.wc_input_table.sortable tbody').sortable({
        items: 'tr',
        cursor: 'move',
        axis: 'y',
        scrollSensitivity: 40,
        forcePlaceholderSize: true,
        helper: 'clone',
        opacity: 0.65,
        placeholder: 'wc-metabox-sortable-placeholder',
        start: function (event, ui) {
            ui.item.css('background-color', '#f6f6f6');
        },
        stop: function (event, ui) {
            ui.item.removeAttr('style');
        },
    });
    // Focus on inputs within the table if clicked instead of trying to sort.
    $('.wc_input_table.sortable tbody input').on('click', function () {
        $(this).trigger('focus');
    });

});


function license_check_status(license = '') {
    jQuery.ajax({
        url: aw_shipping.ajax_url,
        type: 'POST',
        data: {
            action: 'agenwebsite_shipping_license_status',
            _wpnonce: aw_shipping._wpnonce,
            license: license
        },
        success: function (response) {
            jQuery('#wc_agenwebsite_status tbody').html(response.message);
        },
        error: function(response) {
            jQuery('#wc_agenwebsite_status tbody').html('Gagal terhubung dengan AgenWebsite');
        }
    })
}