<?php
/**
 *
 * @link                https://www.agenwebsite.com
 * @since               1.0.0
 * @package             AgenWebsite Shipping
 *
 * @wordpress-plugin
 * Plugin Name:         AgenWebsite Shipping - Plugin Ongkos Kirim Semua Kurir di Indonesia
 * Plugin URI:          https://www.agenwebsite.com/products/agenwebsite-shipping
 * Description:         Plugin untuk WooCommerce dengan penambahan metode shipping di Indonesia.
 * Version:             2.1.4
 * Author:              AgenWebsite
 * Author URI:          https://www.agenwebsite.com
 * License:             GPL-2.0+
 * License URI:         http://www.gnu.org/licenses/gpl-2.0.txt
 * WC requires at least: 9.0.0
 * WC tested up to: 9.4.3
 */

if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

/**
 * Retreive plugin url
 *
 * @access  public
 * @return  string  Plugin URL with plugin slug
 * @since   1.0.0
 */
function aw_shipping_plugin_url()
{
    return untrailingslashit(plugins_url('/', __FILE__));
}

/**
 * Retreive plugin path directory
 *
 * @access  public
 * @return  string  Plugin directory
 * @since   1.0.0
 */
function aw_shipping_plugin_path()
{
    return __DIR__;
}

/**
 * Retreive plugin file
 *
 * @access  public
 * @return  string  Plugin file
 * @since   1.0.0
 */
function aw_shipping_plugin_file()
{
    return __FILE__;
}

add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'aw_shipping_settings_links');
function aw_shipping_settings_links($links)
{
    $plugin_links = array(
        '<a href="' . admin_url('admin.php?page=agenwebsite_shipping') . '">' . __('Settings', 'agenwebsite-shipping') . '</a>',
    );

    return array_merge($plugin_links, $links);
}

add_action('wp_enqueue_scripts', 'aw_shipping_enqueue_scripts', 10);
function aw_shipping_enqueue_scripts()
{
    if (is_checkout()) {
        wp_enqueue_style('aw-shipping', aw_shipping_plugin_url() . '/assets/css/agenwebsite-shipping.css', array('select2'), '1.0.0', 'all');
        wp_enqueue_script('aw-shipping', aw_shipping_plugin_url() . '/assets/js/agenwebsite-shipping.js', array('jquery', 'select2'), '1.0.0', true);

        $woo_blocks_warning_message = '';
        ob_start();
        require aw_shipping_plugin_path() . '/views/frontend/woocommerce-blocks-warning-message.php';
        $woo_blocks_warning_message = ob_get_clean();

        $localize = [
            'ajax_url' => admin_url('admin-ajax.php'),
            '_wpnonce' => wp_create_nonce('aw_shipping_nonce'),
            'woo_blocks_warning_message' => $woo_blocks_warning_message,
        ];
        wp_localize_script('aw-shipping', 'aw_shipping', $localize);
    }
}

require_once 'vendor/plugin-update-checker/plugin-update-checker.php';

use YahnisElsts\PluginUpdateChecker\v5\PucFactory;

$myUpdateChecker = PucFactory::buildUpdateChecker(
    'https://update.agenwebsite.com/?action=get_metadata&slug=agenwebsite-shipping',
    __FILE__,
    'agenwebsite-shipping'
);

add_action('before_woocommerce_init', function () {
    if (class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class)) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
    }
});

require_once 'includes/function-shipping.php';
require_once 'includes/class-settings.php';
require_once 'includes/class-woocommerce-frontend.php';
require_once 'includes/class-api.php';
require_once 'includes/class-ajax.php';
require_once 'includes/class-insurance.php';
require_once 'includes/class-check-ongkir.php';
require_once 'includes/class-tracking.php';
require_once 'includes/class-instant-courier.php';